/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec.docker;

import de.mklinger.commons.exec.CmdBuilder;
import de.mklinger.commons.exec.CmdBuilderBase;
import de.mklinger.commons.exec.CmdException;
import de.mklinger.commons.exec.CmdOutputUtil;
import de.mklinger.commons.exec.CmdSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DockerCmdBuilderBase<B extends CmdBuilderBase<B>>
extends CmdBuilderBase<B> {
    private String dockerExecutable = "docker";
    private final String[] dockerCommands;
    private String dockerMachine;
    private String dockerMachineExecutable = "docker-machine";
    private static final Pattern ENV_LINE = Pattern.compile("SET\\s+([^=]+)=(.*)");

    public DockerCmdBuilderBase(String ... dockerCommands) {
        this.dockerCommands = dockerCommands;
    }

    public B dockerExecutable(String dockerExecutable) {
        this.dockerExecutable = dockerExecutable;
        return (B)this.getBuilder();
    }

    public B dockerMachine(String dockerMachine) {
        this.dockerMachine = dockerMachine;
        return (B)this.getBuilder();
    }

    protected String getDockerMachine() {
        return this.dockerMachine;
    }

    public B dockerMachineExecutable(String dockerMachineExecutable) {
        this.dockerMachineExecutable = dockerMachineExecutable;
        return (B)this.getBuilder();
    }

    public CmdSettings toCmdSettings() {
        CmdSettings cmdSettings = super.toCmdSettings();
        ArrayList<String> command = cmdSettings.getCommand();
        if (command == null) {
            command = new ArrayList<String>();
            cmdSettings.setCommand(command);
        }
        command.add(0, this.dockerExecutable);
        for (int i = this.dockerCommands.length - 1; i >= 0; --i) {
            command.add(1, this.dockerCommands[i]);
        }
        if (this.dockerMachine != null) {
            try {
                String envOutput = CmdOutputUtil.executeForStdout((CmdBuilderBase)((CmdBuilder)((CmdBuilder)((CmdBuilder)new CmdBuilder(this.dockerMachineExecutable).arg((Object)"env")).arg((Object)"--shell")).arg((Object)"cmd")).arg((Object)this.dockerMachine));
                Map<String, String> env = this.parseDockerMachineEnv(envOutput);
                Map oldEnvironment = cmdSettings.getEnvironment();
                if (oldEnvironment != null) {
                    env.putAll(oldEnvironment);
                }
                cmdSettings.setEnvironment(env);
            }
            catch (CmdException e) {
                throw new RuntimeException("Error executing docker-machine", e);
            }
        }
        return cmdSettings;
    }

    private Map<String, String> parseDockerMachineEnv(String envOutput) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer lineTokenizer = new StringTokenizer(envOutput, "\n");
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken().trim();
            if (line.isEmpty() || line.startsWith("REM")) continue;
            Matcher m = ENV_LINE.matcher(line);
            if (m.matches()) {
                String name = m.group(1);
                String value = m.group(2).replace("%%", "%");
                result.put(name, value);
                continue;
            }
            throw new RuntimeException("Invalid line: '" + line + "'");
        }
        return result;
    }

    protected static String requireNonEmpty(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return s;
    }
}

