/*
 * Decompiled with CFR 0.152.
 */
package de.mkammerer.argon2;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2d;
import de.mkammerer.argon2.Argon2i;

public final class Argon2Factory {
    private Argon2Factory() {
    }

    public static Argon2 create() {
        return Argon2Factory.create(Argon2Types.ARGON2i, 16, 32);
    }

    public static Argon2 create(int saltLen, int hashLen) {
        return Argon2Factory.create(Argon2Types.ARGON2i, saltLen, hashLen);
    }

    public static Argon2 create(Argon2Types type) {
        return Argon2Factory.create(type, 16, 32);
    }

    public static Argon2 create(Argon2Types type, int saltLen, int hashLen) {
        switch (type) {
            case ARGON2i: {
                return new Argon2i(saltLen, hashLen);
            }
            case ARGON2d: {
                return new Argon2d(saltLen, hashLen);
            }
        }
        throw new IllegalArgumentException("Invalid argon2 type");
    }

    public static enum Argon2Types {
        ARGON2i,
        ARGON2d;

    }
}

