/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import de.mhus.lib.adb.Persistable;
import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationToIfcProxy;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.core.util.Version;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.osgi.api.services.MOsgi;
import de.mhus.osgi.sop.api.SopApi;
import de.mhus.osgi.sop.api.dfs.FileQueueApi;
import de.mhus.osgi.sop.api.mailqueue.MailMessage;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import de.mhus.osgi.sop.api.util.SopUtil;
import de.mhus.osgi.sop.mailqueue.MailQueueTimer;
import de.mhus.osgi.sop.mailqueue.SopMailTask;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={Operation.class})
public class MailQueueOperationImpl
extends OperationToIfcProxy
implements MailQueueOperation {
    public UUID[] scheduleHtmlMail(String source, String from, String to, String subject, String content, IReadProperties properties, String ... attachments) throws MException {
        MailMessage msg = new MailMessage(source, from, to, null, null, subject, content, attachments, false);
        this.scheduleHtmlMail(msg, properties);
        return msg.getTasks();
    }

    public void scheduleHtmlMail(MailMessage mails, IReadProperties properties) throws MException {
        if (mails == null) {
            this.log().d(new Object[]{"mails are null"});
            return;
        }
        SopApi api = (SopApi)M.l(SopApi.class);
        for (MailMessage mail : mails.getSeparateMails()) {
            SopMailTask task = (SopMailTask)api.getManager().inject((Persistable)new SopMailTask(mail));
            if (properties != null) {
                task.getProperties().putReadProperties(properties);
            }
            task.save();
            try {
                File dir = MailQueueOperationImpl.getMailFolder(task);
                if (mail.getContent().startsWith("dfq:")) {
                    FileQueueApi dfq = (FileQueueApi)M.l(FileQueueApi.class);
                    File contentFrom = dfq.loadFile(MUri.toUri((String)mail.getContent()));
                    MFile.copyFile((File)contentFrom, (File)new File(dir, "content.html"));
                } else {
                    MFile.writeFile((File)new File(dir, "content.html"), (String)mail.getContent());
                }
                MProperties prop = new MProperties();
                if (mail.getAttachments() != null && mail.getAttachments().length > 0) {
                    FileQueueApi dfq = (FileQueueApi)M.l(FileQueueApi.class);
                    int cnt = 0;
                    for (String atta : mail.getAttachments()) {
                        File file = dfq.loadFile(MUri.toUri((String)atta));
                        File dest = new File(dir, "attachment" + cnt);
                        MFile.copyFile((File)file, (File)dest);
                        prop.setString("attachment" + cnt, atta);
                        ++cnt;
                    }
                    prop.setInt("attachments", cnt);
                }
                prop.save(new File(dir, "config.properties"));
                task.setStatus(MailQueueOperation.STATUS.READY);
                task.save();
                mails.addTaskId(task.getId());
                if (!task.getProperties().getBoolean("sendImmediately", true)) continue;
                MailQueueTimer.instance().sendMail(task);
            }
            catch (Throwable t) {
                this.log().w(new Object[]{t});
                task.setStatus(MailQueueOperation.STATUS.ERROR_PREPARE);
                task.setLastError(t.toString());
                task.save();
                return;
            }
        }
    }

    public static File getMailFolder(SopMailTask task) {
        File dir = SopUtil.getFile((String)("mailqueue/mails/" + task.getId()));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static MProperties getSourceConfig(SopMailTask task) {
        File file = SopUtil.getFile((String)("mailqueue/sources/" + task.getSource() + ".properties"));
        if (!file.exists()) {
            return new MProperties();
        }
        return MProperties.load((File)file);
    }

    protected Class<?> getInterfaceClass() {
        return MailQueueOperation.class;
    }

    protected Object getInterfaceObject() {
        return this;
    }

    protected Version getInterfaceVersion() {
        return MOsgi.getBundelVersion(((Object)((Object)this)).getClass());
    }

    protected void initOperationDescription(HashMap<String, String> parameters) {
    }

    public MailQueueOperation.STATUS getStatus(UUID id) throws MException {
        SopApi api = (SopApi)M.l(SopApi.class);
        SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
        if (task == null) {
            throw new NotFoundException(new Object[]{id});
        }
        return task.getStatus();
    }

    public Date getLastSendAttempt(UUID id) throws MException {
        SopApi api = (SopApi)M.l(SopApi.class);
        SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
        if (task == null) {
            throw new NotFoundException(new Object[]{id});
        }
        return task.getLastSendAttempt();
    }
}

