/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import de.mhus.lib.adb.query.Db;
import de.mhus.lib.annotations.util.Interval;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.cfg.CfgInt;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.concurrent.Lock;
import de.mhus.lib.core.mail.MSendMail;
import de.mhus.lib.core.mail.MailAttachment;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.xdb.XdbService;
import de.mhus.osgi.services.scheduler.SchedulerService;
import de.mhus.osgi.services.scheduler.SchedulerServiceAdapter;
import de.mhus.osgi.sop.api.SopApi;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import de.mhus.osgi.sop.mailqueue.MailQueueOperationImpl;
import de.mhus.osgi.sop.mailqueue.SopMailTask;
import de.mhus.osgi.sop.mailqueue._SopMailTask;
import java.io.File;
import java.util.Date;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Interval(value="interval=*/5 * * * * *")
@Component(service={SchedulerService.class}, immediate=true)
public class MailQueueTimer
extends SchedulerServiceAdapter {
    private static final CfgInt CFG_MAX_ATTEMPTS = new CfgInt(MailQueueOperation.class, "maxAttempts", 10);
    private static final CfgInt CFG_MAX_MAILS_PER_ROUND = new CfgInt(MailQueueOperation.class, "maxMailsPerRound", 30);
    private static final CfgString CFG_NEXT_SEND_ATTEMPT_INTERVAL = new CfgString(MailQueueOperation.class, "nextSendAttemptInterval", "15m");
    private static final long LOCK_TIMEOUT = 60000L;
    private static MailQueueTimer instance;
    private Lock lock = new Lock("MailQueueLock");

    @Activate
    public void doActivate(ComponentContext ctx) {
        System.out.println("Start CryptaDbSchema");
        instance = this;
    }

    @Deactivate
    public void doDeactivate(ComponentContext ctx) {
        instance = null;
    }

    static MailQueueTimer instance() {
        return instance;
    }

    public void run(Object environment) {
        try {
            Date now = new Date();
            XdbService manager = ((SopApi)M.l(SopApi.class)).getManager();
            if (manager == null) {
                this.log().w(new Object[]{"XdbService is null"});
                return;
            }
            int mailCnt = 0;
            for (SopMailTask task : manager.getByQualification(Db.query(SopMailTask.class).eq(_SopMailTask._STATUS, (Object)MailQueueOperation.STATUS.READY).le(_SopMailTask._NEXT_SEND_ATTEMPT, (Object)now))) {
                if ((Integer)CFG_MAX_MAILS_PER_ROUND.value() > 0 && ++mailCnt > (Integer)CFG_MAX_MAILS_PER_ROUND.value()) continue;
                this.sendMail(task);
            }
        }
        catch (Throwable t) {
            this.log().e(new Object[]{t});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendMail(SopMailTask task) throws Exception {
        if (!this.lock.lock(60000L)) {
            this.log().w(new Object[]{"can't obtain lock", this.lock});
            return false;
        }
        try {
            task.reload();
            if (task.getStatus() != MailQueueOperation.STATUS.READY) {
                this.log().d(new Object[]{"Ignore Mail: wrong status", task});
                boolean bl = false;
                return bl;
            }
            this.sendMailInternal(task);
            task.setStatus(MailQueueOperation.STATUS.SENT);
            task.save();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    private void sendMailInternal(SopMailTask task) throws Exception {
        MProperties source = MailQueueOperationImpl.getSourceConfig(task);
        File dir = MailQueueOperationImpl.getMailFolder(task);
        MProperties prop = MProperties.load((File)new File(dir, "config.properties"));
        MailAttachment[] attachments = null;
        if (prop.getInt("attachmnets", 0) > 0) {
            attachments = new MailAttachment[prop.getInt("attachmnets", 0)];
            for (int i = 0; i < attachments.length; ++i) {
                String name = MFile.getFileName((String)MUri.toUri((String)prop.getString("attachment" + i)).getPath());
                attachments[i] = new MailAttachment(new File(dir, "attachment" + i), name, false);
            }
        }
        String html = MFile.readFile((File)new File(dir, "content.html"));
        this.log().d(new Object[]{"send", task});
        String to = source.getString("to", task.getTo());
        String cc = source.getString("cc", task.getCc());
        String bcc = source.getString("bcc", task.getBcc());
        ((MSendMail)M.l(MSendMail.class)).sendHtmlMail(task.getFrom(), this.toMailArray(to), this.toMailArray(cc), this.toMailArray(bcc), task.getSubject(), html, attachments);
        if (source.getBoolean("cleanupAfterSent", true)) {
            this.log().d(new Object[]{"cleanup", task, dir});
            MFile.deleteDir((File)dir);
        }
    }

    private String[] toMailArray(String to) {
        if (to == null) {
            return null;
        }
        return to.split(";");
    }
}

