/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import de.mhus.lib.adb.DbMetadata;
import de.mhus.lib.annotations.adb.DbPersistent;
import de.mhus.lib.annotations.adb.DbType;
import de.mhus.lib.basics.consts.GenerateConst;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.errors.MException;
import de.mhus.osgi.sop.api.mailqueue.MailMessage;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import java.util.Date;

@GenerateConst
public class SopMailTask
extends DbMetadata {
    @DbPersistent
    private String source;
    @DbPersistent
    private String from;
    @DbPersistent
    private String to;
    @DbPersistent
    private String cc;
    @DbPersistent
    private String bcc;
    @DbPersistent
    private String subject;
    @DbPersistent
    private MailQueueOperation.STATUS status = MailQueueOperation.STATUS.NEW;
    @DbPersistent
    private Date lastSendAttempt;
    @DbPersistent
    private Date nextSendAttempt = new Date();
    @DbPersistent(type=DbType.TYPE.STRING, size=700)
    private String lastError;
    @DbPersistent
    private int sendAttempts = 0;
    @DbPersistent
    private MProperties properties;

    public SopMailTask() {
    }

    public SopMailTask(MailMessage mail) {
        this(mail.getSource(), mail.getFrom(), mail.getTo(), mail.getCc(), mail.getBcc(), mail.getSubject());
    }

    public SopMailTask(String source, String from, String to, String cc, String bcc, String subject) {
        this.source = source;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = M.trunc((String)subject, (int)200);
        this.properties = new MProperties();
    }

    public DbMetadata findParentObject() throws MException {
        return null;
    }

    public MailQueueOperation.STATUS getStatus() {
        return this.status;
    }

    public void setStatus(MailQueueOperation.STATUS status) {
        this.status = status;
    }

    public Date getLastSendAttempt() {
        return this.lastSendAttempt;
    }

    public void setLastSendAttempt(Date lastSendAttempt) {
        this.lastSendAttempt = lastSendAttempt;
    }

    public Date getNextSendAttempt() {
        return this.nextSendAttempt;
    }

    public void setNextSendAttempt(Date nextSendAttempt) {
        this.nextSendAttempt = nextSendAttempt;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = M.trunc((String)lastError, (int)700);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getSendAttempts() {
        return this.sendAttempts;
    }

    public void setSendAttempts(int sendAttempts) {
        this.sendAttempts = sendAttempts;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return MSystem.toString((Object)((Object)this), (Object[])new Object[]{this.getId(), this.source, this.to, this.subject});
    }

    public MProperties getProperties() {
        return this.properties;
    }
}

