/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import de.mhus.lib.adb.query.AQuery;
import de.mhus.lib.adb.query.Db;
import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.xdb.XdbService;
import de.mhus.osgi.sop.api.SopApi;
import de.mhus.osgi.sop.api.mailqueue.MailMessage;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import de.mhus.osgi.sop.api.mailqueue.MutableMailMessage;
import de.mhus.osgi.sop.api.operation.OperationUtil;
import de.mhus.osgi.sop.mailqueue.MailQueueTimer;
import de.mhus.osgi.sop.mailqueue.SopMailTask;
import de.mhus.osgi.sop.mailqueue._SopMailTask;
import java.util.Arrays;
import java.util.UUID;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="sop", name="mailqueue", description="Main queue actions")
@Service
public class MailQueueCmd
implements Action {
    @Argument(index=0, name="cmd", required=true, description="Command:\n new <source> <from> <to> <subject> <content html> [attachments]\n list\n status <id>\n retry [<id>]\n lost [<id>]\n send <id>\n clenanup\n delete <id>")
    String cmd;
    @Argument(index=1, name="parameters", required=false, description="More Parameters", multiValued=true)
    String[] parameters;
    @Option(name="-a", aliases={"--all"}, description="All", required=false)
    boolean all = false;
    @Option(name="-f", aliases={"--force"}, description="Force action", required=false)
    boolean force = false;
    @Option(name="-ct", aliases={"--table"}, description="Table output", required=false)
    String ct;
    @Option(name="-cc", description="CC", required=false, multiValued=true)
    String[] cc;
    @Option(name="-bcc", description="BCC", required=false, multiValued=true)
    String[] bcc;
    @Option(name="-p", aliases={"--property"}, description="Additional send properties: sendImmediately=false", required=false, multiValued=true)
    String[] p;
    @Option(name="-i", aliases={"--individual"}, description="Individual Mails for each recipient", required=false)
    boolean individual = false;

    public Object execute() throws Exception {
        switch (this.cmd) {
            case "list": {
                ConsoleTable table = new ConsoleTable(this.ct);
                table.setHeaderValues(new String[]{"id", "source", "status", "next", "to", "subject", "attempts", "created"});
                XdbService manager = ((SopApi)MApi.lookup(SopApi.class)).getManager();
                AQuery q = Db.query(SopMailTask.class);
                if (!this.all) {
                    q.eq(_SopMailTask._STATUS, (Object)MailQueueOperation.STATUS.READY);
                }
                for (SopMailTask task : manager.getByQualification(q)) {
                    table.addRowValues(new Object[]{task.getId(), task.getSource(), task.getStatus(), task.getNextSendAttempt(), task.getTo() + (String)(task.getCc() != null ? "\nCC:" + task.getCc() : "") + (String)(task.getBcc() != null ? "\nBCC:" + task.getBcc() : ""), task.getSubject(), task.getSendAttempts(), task.getCreationDate()});
                }
                table.print(System.out);
                break;
            }
            case "new": {
                MailQueueOperation mq = (MailQueueOperation)OperationUtil.getOperationIfc(MailQueueOperation.class);
                String[] attachments = null;
                if (this.parameters.length > 4) {
                    attachments = new String[this.parameters.length - 4];
                    for (int i = 5; i < this.parameters.length; ++i) {
                        attachments[i - 5] = this.parameters[i];
                    }
                }
                MutableMailMessage msg = new MutableMailMessage();
                msg.setSource(this.parameters[0]);
                msg.setFrom(this.parameters[1]);
                msg.setTo(this.parameters[2]);
                msg.setSubject(this.parameters[3]);
                msg.setContent(this.parameters[4]);
                msg.setCc(this.cc);
                msg.setBcc(this.bcc);
                msg.setIndividual(this.individual);
                MProperties prop = null;
                if (this.p != null) {
                    prop = MProperties.explodeToMProperties((String[])this.p);
                }
                MailMessage m = msg.toMessage();
                mq.scheduleHtmlMail(m, (IReadProperties)prop);
                System.out.println("Scheduled as " + Arrays.toString(m.getTasks()));
                break;
            }
            case "status": {
                MailQueueOperation mq = (MailQueueOperation)OperationUtil.getOperationIfc(MailQueueOperation.class);
                UUID id = UUID.fromString(this.parameters[0]);
                MailQueueOperation.STATUS status = mq.getStatus(id);
                System.out.println("Status: " + status);
                break;
            }
            case "retry": {
                if (this.parameters == null || this.parameters.length == 0) {
                    XdbService manager = ((SopApi)MApi.lookup(SopApi.class)).getManager();
                    for (SopMailTask task : manager.getByQualification(Db.query(SopMailTask.class).eq(_SopMailTask._STATUS, (Object)MailQueueOperation.STATUS.ERROR))) {
                        System.out.println((Object)task);
                        task.setStatus(MailQueueOperation.STATUS.READY);
                        task.save();
                    }
                    break;
                }
                UUID id = UUID.fromString(this.parameters[0]);
                SopApi api = (SopApi)MApi.lookup(SopApi.class);
                SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
                if (this.force || task.getStatus() == MailQueueOperation.STATUS.ERROR || task.getStatus() == MailQueueOperation.STATUS.ERROR_PREPARE) {
                    task.setStatus(MailQueueOperation.STATUS.READY);
                    task.save();
                    System.out.println("OK");
                    break;
                }
                System.out.println("Task is not in ERROR");
                break;
            }
            case "send": {
                UUID id = UUID.fromString(this.parameters[0]);
                SopApi api = (SopApi)MApi.lookup(SopApi.class);
                SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
                if (task == null) {
                    System.out.println("Task not found");
                    return null;
                }
                if (this.force || task.getStatus() == MailQueueOperation.STATUS.READY) {
                    MailQueueTimer.instance().sendMail(task);
                    System.out.println("OK " + task);
                    break;
                }
                System.out.println("Task is not ready");
                break;
            }
            case "lost": {
                if (this.parameters == null || this.parameters.length == 0) {
                    XdbService manager = ((SopApi)MApi.lookup(SopApi.class)).getManager();
                    for (SopMailTask task : manager.getByQualification(Db.query(SopMailTask.class).eq(_SopMailTask._STATUS, (Object)MailQueueOperation.STATUS.ERROR))) {
                        System.out.println((Object)task);
                        task.setStatus(MailQueueOperation.STATUS.LOST);
                        task.save();
                    }
                    break;
                }
                UUID id = UUID.fromString(this.parameters[0]);
                SopApi api = (SopApi)MApi.lookup(SopApi.class);
                SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
                if (this.force || task.getStatus() == MailQueueOperation.STATUS.ERROR || task.getStatus() == MailQueueOperation.STATUS.ERROR_PREPARE) {
                    task.setStatus(MailQueueOperation.STATUS.LOST);
                    task.save();
                    System.out.println("OK");
                    break;
                }
                System.out.println("Task is not in ERROR");
                break;
            }
            case "cleanup": {
                XdbService manager = ((SopApi)MApi.lookup(SopApi.class)).getManager();
                for (SopMailTask task : manager.getByQualification(Db.query(SopMailTask.class).eq(_SopMailTask._STATUS, (Object)MailQueueOperation.STATUS.ERROR))) {
                    if (task.getStatus() == MailQueueOperation.STATUS.NEW || task.getStatus() == MailQueueOperation.STATUS.READY || task.getStatus() == MailQueueOperation.STATUS.ERROR) continue;
                    System.out.println((Object)task);
                    task.delete();
                }
                break;
            }
            case "delete": {
                UUID id = UUID.fromString(this.parameters[0]);
                SopApi api = (SopApi)MApi.lookup(SopApi.class);
                SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
                if (this.force || task.getStatus() == MailQueueOperation.STATUS.ERROR || task.getStatus() == MailQueueOperation.STATUS.ERROR_PREPARE || task.getStatus() == MailQueueOperation.STATUS.SENT || task.getStatus() == MailQueueOperation.STATUS.LOST) {
                    task.setStatus(MailQueueOperation.STATUS.LOST);
                    task.delete();
                    System.out.println("Deleted");
                    break;
                }
                System.out.println("Task is not in ERROR");
            }
        }
        return null;
    }
}

