/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import de.mhus.lib.adb.DbMetadata;
import de.mhus.lib.annotations.adb.DbPersistent;
import de.mhus.lib.annotations.adb.DbType;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.errors.MException;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import java.util.Date;

public class SopMailTask
extends DbMetadata {
    @DbPersistent
    private String source;
    @DbPersistent
    private String from;
    @DbPersistent
    private String to;
    @DbPersistent
    private String subject;
    @DbPersistent
    private MailQueueOperation.STATUS status = MailQueueOperation.STATUS.NEW;
    @DbPersistent
    private Date lastSendAttempt;
    @DbPersistent
    private Date nextSendAttempt = new Date();
    @DbPersistent(type=DbType.TYPE.STRING, size=700)
    private String lastError;
    @DbPersistent
    private int sendAttempts = 0;

    public SopMailTask() {
    }

    public SopMailTask(String source, String from, String to, String subject) {
        this.source = source;
        this.from = from;
        this.to = to;
        this.subject = M.trunc((String)subject, (int)200);
    }

    public DbMetadata findParentObject() throws MException {
        return null;
    }

    public MailQueueOperation.STATUS getStatus() {
        return this.status;
    }

    public void setStatus(MailQueueOperation.STATUS status) {
        this.status = status;
    }

    public Date getLastSendAttempt() {
        return this.lastSendAttempt;
    }

    public void setLastSendAttempt(Date lastSendAttempt) {
        this.lastSendAttempt = lastSendAttempt;
    }

    public Date getNextSendAttempt() {
        return this.nextSendAttempt;
    }

    public void setNextSendAttempt(Date nextSendAttempt) {
        this.nextSendAttempt = nextSendAttempt;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = M.trunc((String)lastError, (int)700);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getSendAttempts() {
        return this.sendAttempts;
    }

    public void setSendAttempts(int sendAttempts) {
        this.sendAttempts = sendAttempts;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return MSystem.toString((Object)((Object)this), (Object[])new Object[]{this.getId(), this.source, this.to, this.subject});
    }
}

