/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import aQute.bnd.annotation.component.Component;
import de.mhus.lib.adb.query.Db;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.mail.MSendMail;
import de.mhus.lib.core.mail.MailAttachment;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.xdb.XdbService;
import de.mhus.osgi.services.scheduler.SchedulerService;
import de.mhus.osgi.services.scheduler.SchedulerServiceAdapter;
import de.mhus.osgi.sop.api.SopApi;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import de.mhus.osgi.sop.mailqueue.MailQueueOperationImpl;
import de.mhus.osgi.sop.mailqueue.SopMailTask;
import java.io.File;
import java.util.Date;

@Component(provide={SchedulerService.class}, immediate=true, properties={"interval=*/15 * * * * *"})
public class MailQueueTimer
extends SchedulerServiceAdapter {
    private static final int MAX_ATTEMPTS = 10;

    public void run(Object environment) {
        try {
            Date now = new Date();
            XdbService manager = ((SopApi)MApi.lookup(SopApi.class)).getManager();
            for (SopMailTask task : manager.getByQualification(Db.query(SopMailTask.class).eq(SopMailTask::getStatus, (Object)MailQueueOperation.STATUS.READY).le(SopMailTask::getNextSendAttempt, (Object)now))) {
                try {
                    this.sendMail(task);
                    task.setStatus(MailQueueOperation.STATUS.SENT);
                    task.save();
                }
                catch (Throwable t) {
                    this.log().e(new Object[]{t});
                    task.setSendAttempts(task.getSendAttempts() + 1);
                    if (task.getSendAttempts() > 10) {
                        task.setStatus(MailQueueOperation.STATUS.ERROR);
                    } else {
                        task.setNextSendAttempt(new Date(System.currentTimeMillis() + 900000L));
                    }
                    task.setLastError(t.toString());
                    task.save();
                }
            }
        }
        catch (Throwable t) {
            this.log().e(new Object[]{t});
        }
    }

    private void sendMail(SopMailTask task) throws Exception {
        MProperties source = MailQueueOperationImpl.getSourceConfig(task);
        File dir = MailQueueOperationImpl.getMailFolder(task);
        MProperties prop = MProperties.load((File)new File(dir, "config.properties"));
        MailAttachment[] attachments = null;
        if (prop.getInt("attachmnets", 0) > 0) {
            attachments = new MailAttachment[prop.getInt("attachmnets", 0)];
            for (int i = 0; i < attachments.length; ++i) {
                String name = MFile.getFileName((String)MUri.toUri((String)prop.getString("attachment" + i)).getPath());
                attachments[i] = new MailAttachment(new File(dir, "attachment" + i), name, false);
            }
        }
        String html = MFile.readFile((File)new File(dir, "content.html"));
        this.log().d(new Object[]{"send", task});
        String to = source.getString("to", task.getTo());
        String cc = source.getString("cc", null);
        String bcc = source.getString("bcc", null);
        ((MSendMail)MApi.lookup(MSendMail.class)).sendHtmlMail(task.getFrom(), new String[]{to}, new String[]{cc}, new String[]{bcc}, task.getSubject(), html, attachments);
        if (source.getBoolean("cleanupAfterSent", true)) {
            this.log().d(new Object[]{"cleanup", task, dir});
            MFile.deleteDir((File)dir);
        }
    }
}

