/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import aQute.bnd.annotation.component.Component;
import de.mhus.lib.adb.Persistable;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationToIfcProxy;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.core.util.Version;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.osgi.services.MOsgi;
import de.mhus.osgi.sop.api.SopApi;
import de.mhus.osgi.sop.api.dfs.FileQueueApi;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import de.mhus.osgi.sop.api.util.SopUtil;
import de.mhus.osgi.sop.mailqueue.SopMailTask;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;

@Component(immediate=true, provide={Operation.class})
public class MailQueueOperationImpl
extends OperationToIfcProxy
implements MailQueueOperation {
    public UUID scheduleHtmlMail(String source, String from, String[] to, String subject, String content, String ... attachments) throws MException {
        UUID res = null;
        for (String t : to) {
            UUID r = this.scheduleHtmlMail(source, from, t, subject, content, attachments);
            if (res != null) continue;
            res = r;
        }
        return res;
    }

    public UUID scheduleHtmlMail(String source, String from, String to, String subject, String content, String ... attachments) throws MException {
        SopApi api = (SopApi)MApi.lookup(SopApi.class);
        SopMailTask task = (SopMailTask)api.getManager().inject((Persistable)new SopMailTask(source, from, to, subject));
        task.save();
        try {
            File dir = MailQueueOperationImpl.getMailFolder(task);
            if (content.startsWith("dfq:")) {
                FileQueueApi dfq = (FileQueueApi)MApi.lookup(FileQueueApi.class);
                File contentFrom = dfq.loadFile(MUri.toUri((String)content));
                MFile.copyFile((File)contentFrom, (File)new File(dir, "content.html"));
            } else {
                MFile.writeFile((File)new File(dir, "content.html"), (String)content);
            }
            MProperties prop = new MProperties();
            if (attachments != null && attachments.length > 0) {
                FileQueueApi dfq = (FileQueueApi)MApi.lookup(FileQueueApi.class);
                int cnt = 0;
                for (String atta : attachments) {
                    File file = dfq.loadFile(MUri.toUri((String)atta));
                    File dest = new File(dir, "attachment" + cnt);
                    MFile.copyFile((File)file, (File)dest);
                    prop.setString("attachment" + cnt, atta);
                    ++cnt;
                }
                prop.setInt("attachments", cnt);
            }
            prop.save(new File(dir, "config.properties"));
            task.setStatus(MailQueueOperation.STATUS.READY);
            task.save();
            return task.getId();
        }
        catch (Throwable t) {
            this.log().w(new Object[]{t});
            task.setStatus(MailQueueOperation.STATUS.ERROR_PREPARE);
            task.setLastError(t.toString());
            task.save();
            return null;
        }
    }

    public static File getMailFolder(SopMailTask task) {
        File dir = SopUtil.getFile((String)("mailqueue/mails/" + task.getId()));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static MProperties getSourceConfig(SopMailTask task) {
        File file = SopUtil.getFile((String)("mailqueue/sources/" + task.getSource() + ".properties"));
        if (!file.exists()) {
            return new MProperties();
        }
        return MProperties.load((File)file);
    }

    protected Class<?> getInterfaceClass() {
        return MailQueueOperation.class;
    }

    protected Object getInterfaceObject() {
        return this;
    }

    protected Version getInterfaceVersion() {
        return MOsgi.getBundelVersion(((Object)((Object)this)).getClass());
    }

    protected void initOperationDescription(HashMap<String, String> parameters) {
    }

    public MailQueueOperation.STATUS getStatus(UUID id) throws MException {
        SopApi api = (SopApi)MApi.lookup(SopApi.class);
        SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
        if (task == null) {
            throw new NotFoundException(new Object[]{id});
        }
        return task.getStatus();
    }
}

