/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.osgi.sop.mailqueue;

import de.mhus.lib.core.MApi;
import de.mhus.osgi.sop.api.SopApi;
import de.mhus.osgi.sop.api.mailqueue.MailQueueOperation;
import de.mhus.osgi.sop.api.operation.OperationUtil;
import de.mhus.osgi.sop.mailqueue.SopMailTask;
import java.util.UUID;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="sop", name="mailqueue", description="Main queue actions")
@Service
public class MailQueueCmd
implements Action {
    @Argument(index=0, name="cmd", required=true, description="Command:\n send <source> <from> <to> <subject> <content html> [attachments]")
    String cmd;
    @Argument(index=1, name="parameters", required=false, description="More Parameters", multiValued=true)
    String[] parameters;
    @Option(name="-f", aliases={"--full"}, description="Full output", required=false)
    boolean full = false;

    public Object execute() throws Exception {
        switch (this.cmd) {
            case "send": {
                MailQueueOperation mq = (MailQueueOperation)OperationUtil.getOperationIfc(MailQueueOperation.class);
                String[] attachments = null;
                if (this.parameters.length > 4) {
                    attachments = new String[this.parameters.length - 4];
                    for (int i = 5; i < this.parameters.length; ++i) {
                        attachments[i - 5] = this.parameters[i];
                    }
                }
                UUID id = mq.scheduleHtmlMail(this.parameters[0], this.parameters[1], this.parameters[2].split(";"), this.parameters[3], this.parameters[4], attachments);
                System.out.println("Scheduled as " + id);
                break;
            }
            case "status": {
                MailQueueOperation mq = (MailQueueOperation)OperationUtil.getOperationIfc(MailQueueOperation.class);
                UUID id = UUID.fromString(this.parameters[0]);
                MailQueueOperation.STATUS status = mq.getStatus(id);
                System.out.println("Status: " + status);
                break;
            }
            case "retry": {
                UUID id = UUID.fromString(this.parameters[0]);
                SopApi api = (SopApi)MApi.lookup(SopApi.class);
                SopMailTask task = (SopMailTask)((Object)api.getManager().getObject(SopMailTask.class, new Object[]{id}));
                if (task.getStatus() != MailQueueOperation.STATUS.ERROR) break;
                task.setStatus(MailQueueOperation.STATUS.READY);
                task.save();
                System.out.println("OK");
            }
        }
        return null;
    }
}

