/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jmx;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import de.mhus.lib.annotations.jmx.JmxManaged;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MPassword;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.jmx.MRemoteManager;
import de.mhus.lib.errors.MException;
import javax.management.ObjectName;

@JmxManaged(descrition="Jmx Http Server")
public class JmxHttpServer
extends MJmx {
    private HtmlAdaptorServer server;
    private IConfig config;

    public void setConfig(IConfig config) {
        this.config = config;
    }

    @JmxManaged
    public void openServer() throws MException {
        if (this.config == null) {
            this.config = MApi.getCfg((Object)((Object)this));
        }
        if (this.config == null || this.server != null) {
            return;
        }
        this.server = new HtmlAdaptorServer(this.config.getInt("port", 1098));
        for (IConfig cuser : this.config.getNodes("user")) {
            this.server.addUserAuthenticationInfo(new AuthInfo(cuser.getExtracted("name"), MPassword.decode((String)cuser.getExtracted("password"))));
        }
        try {
            ((MRemoteManager)MApi.lookup(MRemoteManager.class)).register(new ObjectName("adaptor:proptocol=HTTP"), (Object)this.server, false, false);
            this.server.setMBeanServer(((MRemoteManager)MApi.lookup(MRemoteManager.class)).getMBeanServer());
        }
        catch (Exception e) {
            this.log().w(new Object[]{e});
            this.server = null;
            return;
        }
        this.server.start();
    }

    @JmxManaged
    public void closeServer() {
        if (this.server == null) {
            return;
        }
        this.server.stop();
        this.server = null;
    }
}

