/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.utils;

import android.content.Context;
import android.net.wifi.WifiManager;
import de.mannodermaus.rxbonjour.utils.BonjourUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jmdns.JmDNS;
import javax.jmdns.impl.DNSStatefulObject;

public final class SupportUtils
extends BonjourUtils<JmDNS> {
    private static SupportUtils instance;
    private JmDNS jmdnsInstance;
    private final Object jmdnsLock = new Object();
    private final AtomicInteger jmdnsSubscriberCount = new AtomicInteger(0);

    private SupportUtils() {
    }

    public static SupportUtils get() {
        if (instance == null) {
            instance = new SupportUtils();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmDNS getManager(Context context) throws IOException {
        Object object = this.jmdnsLock;
        synchronized (object) {
            if (this.jmdnsInstance == null || !this.isAvailable()) {
                WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                InetAddress inetAddress = this.getInetAddress(wifiManager);
                this.jmdnsInstance = JmDNS.create((InetAddress)inetAddress, (String)inetAddress.toString());
                this.jmdnsSubscriberCount.set(0);
            }
            return this.jmdnsInstance;
        }
    }

    private boolean isAvailable() {
        if (this.jmdnsInstance != null) {
            DNSStatefulObject dso = (DNSStatefulObject)this.jmdnsInstance;
            return !dso.isClosing() && !dso.isClosed();
        }
        return false;
    }

    public int incrementSubscriberCount() {
        if (this.isAvailable()) {
            return this.jmdnsSubscriberCount.incrementAndGet();
        }
        return 0;
    }

    public int decrementSubscriberCount() {
        if (this.isAvailable()) {
            return this.jmdnsSubscriberCount.decrementAndGet();
        }
        return 0;
    }

    public void closeIfNecessary() {
        if (this.jmdnsInstance != null && this.jmdnsSubscriberCount.get() <= 0) {
            this.close();
        }
    }

    public void close() {
        if (this.jmdnsInstance != null) {
            try {
                this.jmdnsInstance.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.jmdnsSubscriberCount.set(0);
            }
        }
    }
}

