/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour.broadcast;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import java.io.IOException;
import java.util.HashMap;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import rxbonjour.RxBonjourBase;
import rxbonjour.broadcast.BonjourBroadcast;
import rxbonjour.broadcast.BonjourBroadcastBuilder;
import rxbonjour.exc.BroadcastFailed;
import rxbonjour.exc.TypeMalformedException;
import rxbonjour.model.BonjourEvent;
import rxbonjour.model.BonjourListener;
import rxbonjour.model.BonjourService;
import rxbonjour.utils.SupportUtils;

final class SupportBonjourBroadcast
extends BonjourBroadcast<SupportUtils> {
    private static final String LOCK_TAG = "RxBonjourBroadcast";
    private JmDNS jmdns;
    private ServiceInfo jmdnsService;
    private WifiManager.MulticastLock lock;

    protected SupportBonjourBroadcast(BonjourBroadcastBuilder builder) {
        super(builder);
    }

    @Override
    protected SupportUtils createUtils() {
        return SupportUtils.get();
    }

    @Override
    public void start(@NonNull Context context, @NonNull BonjourListener listener) {
        if (!RxBonjourBase.isBonjourType(this.type)) {
            listener.onBonjourError(new TypeMalformedException(this.type));
            return;
        }
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        this.lock = wifiManager.createMulticastLock(LOCK_TAG);
        this.lock.setReferenceCounted(true);
        this.lock.acquire();
        try {
            BonjourService bonjourService = this.createBonjourService(context);
            this.jmdnsService = this.createJmdnsService(bonjourService);
            this.jmdns = ((SupportUtils)this.utils).getManager(context);
            this.jmdns.registerService(this.jmdnsService);
            ((SupportUtils)this.utils).incrementSubscriberCount();
            listener.onBonjourEvent(new BonjourEvent(BonjourEvent.Type.ADDED, bonjourService));
        }
        catch (IOException e) {
            listener.onBonjourError(new BroadcastFailed(SupportBonjourBroadcast.class, this.type));
        }
    }

    @Override
    public void stop() {
        if (this.jmdns != null) {
            this.jmdns.unregisterService(this.jmdnsService);
            ((SupportUtils)this.utils).decrementSubscriberCount();
            this.lock.release();
            new Thread(){

                @Override
                public void run() {
                    super.run();
                    ((SupportUtils)SupportBonjourBroadcast.this.utils).closeIfNecessary();
                }
            }.start();
        }
    }

    private ServiceInfo createJmdnsService(BonjourService serviceInfo) {
        int txtRecordCount = serviceInfo.getTxtRecordCount();
        Bundle txtRecordBundle = serviceInfo.getTxtRecords();
        HashMap<String, String> txtRecordMap = new HashMap<String, String>(txtRecordCount);
        if (txtRecordBundle.size() > 0) {
            for (String key : txtRecordBundle.keySet()) {
                txtRecordMap.put(key, txtRecordBundle.getString(key));
            }
        }
        return ServiceInfo.create((String)serviceInfo.getType(), (String)serviceInfo.getName(), (int)serviceInfo.getPort(), (int)0, (int)0, (boolean)true, txtRecordMap);
    }

    static class Builder
    extends BonjourBroadcastBuilder {
        private static final String SUFFIX = ".local.";

        Builder(String type) {
            super(type.endsWith(SUFFIX) ? type : type + SUFFIX);
        }

        public BonjourBroadcast build() {
            return new SupportBonjourBroadcast(this);
        }
    }
}

