/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour;

import android.content.Context;
import android.support.annotation.NonNull;
import rx.Emitter;
import rx.Observable;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.functions.Action1;
import rxbonjour.RxBonjourBase;
import rxbonjour.broadcast.BonjourBroadcast;
import rxbonjour.discovery.BonjourDiscovery;
import rxbonjour.model.BonjourEvent;
import rxbonjour.model.BonjourListener;

public final class RxBonjour
extends RxBonjourBase {
    private RxBonjour() {
        throw new AssertionError((Object)"no instances");
    }

    public static Observable<BonjourEvent> newDiscovery(@NonNull Context context, @NonNull String type) {
        return RxBonjour.newDiscovery(context, type, false);
    }

    public static Observable<BonjourEvent> newDiscovery(final @NonNull Context context, final @NonNull String type, final boolean forceNsdManager) {
        return Observable.fromEmitter((Action1)new Action1<Emitter<BonjourEvent>>(){

            public void call(final Emitter<BonjourEvent> emitter) {
                final BonjourDiscovery discovery = BonjourDiscovery.get((boolean)forceNsdManager);
                BonjourListener listener = new BonjourListener(){

                    public void onBonjourEvent(@NonNull BonjourEvent event) {
                        emitter.onNext((Object)event);
                    }

                    public void onBonjourError(@NonNull Throwable t) {
                        emitter.onError(t);
                    }
                };
                emitter.setSubscription((Subscription)new MainThreadSubscription(){

                    protected void onUnsubscribe() {
                        discovery.stop();
                    }
                });
                discovery.start(context, type, listener);
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER);
    }

    public static Observable<BonjourEvent> newBroadcast(final @NonNull Context context, final @NonNull BonjourBroadcast<?> broadcast) {
        return Observable.fromEmitter((Action1)new Action1<Emitter<BonjourEvent>>(){

            public void call(final Emitter<BonjourEvent> emitter) {
                BonjourListener listener = new BonjourListener(){

                    public void onBonjourEvent(@NonNull BonjourEvent event) {
                        emitter.onNext((Object)event);
                    }

                    public void onBonjourError(@NonNull Throwable t) {
                        emitter.onError(t);
                    }
                };
                emitter.setSubscription((Subscription)new MainThreadSubscription(){

                    protected void onUnsubscribe() {
                        broadcast.stop();
                    }
                });
                broadcast.start(context, listener);
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER);
    }
}

