/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.importer;

import de.larsgrefer.sass.embedded.importer.CustomUrlImporter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathImporter
extends CustomUrlImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClasspathImporter.class);
    private final ClassLoader classLoader;

    public ClasspathImporter() {
        this(ClasspathImporter.class.getClassLoader());
    }

    @Override
    public URL canonicalizeUrl(String url) throws IOException {
        Enumeration<URL> foundResources = this.classLoader.getResources(url);
        List<URL> foundUrls = this.getNonDirectoryUrls(foundResources);
        if (foundUrls.isEmpty()) {
            return null;
        }
        if (foundUrls.size() == 1) {
            return foundUrls.get(0);
        }
        throw new IllegalStateException(String.format("Import of '%s' found %d results.", url, foundUrls.size()));
    }

    @Nonnull
    private List<URL> getNonDirectoryUrls(Enumeration<URL> foundResources) throws IOException {
        ArrayList<URL> foundUrls = new ArrayList<URL>();
        while (foundResources.hasMoreElements()) {
            URL candidate = foundResources.nextElement();
            if (!this.isFile(candidate)) continue;
            foundUrls.add(candidate);
        }
        return foundUrls;
    }

    @Generated
    public ClasspathImporter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

