/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import de.larsgrefer.sass.embedded.util.ColorValidator;
import de.larsgrefer.sass.embedded.util.CssColorSpecUtil;
import java.awt.Color;
import javax.annotation.Nonnull;
import lombok.Generated;
import sass.embedded_protocol.EmbeddedSass;

@Nonnull
public final class ColorUtil {
    @Deprecated
    public static Color toJavaColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        return ColorUtil.toJavaColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hwbColor));
    }

    @Deprecated
    public static Color toJavaColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        return ColorUtil.toJavaColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hslColor));
    }

    @Deprecated
    public static Color toJavaColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        return new Color(rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue(), (int)(rgbColor.getAlpha() * 255.0));
    }

    public static EmbeddedSass.Value.RgbColor toRgbColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        double[] rgb = CssColorSpecUtil.hwbToRgb(hwbColor.getHue(), hwbColor.getWhiteness(), hwbColor.getBlackness());
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed((int)Math.round(rgb[0] * 255.0)).setGreen((int)Math.round(rgb[1] * 255.0)).setBlue((int)Math.round(rgb[2] * 255.0)).setAlpha(hwbColor.getAlpha()).build();
    }

    public static EmbeddedSass.Value.RgbColor toRgbColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        double[] rgb = CssColorSpecUtil.hslToRgb((int)hslColor.getHue(), hslColor.getSaturation(), hslColor.getLightness());
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed((int)Math.round(rgb[0] * 255.0)).setGreen((int)Math.round(rgb[1] * 255.0)).setBlue((int)Math.round(rgb[2] * 255.0)).setAlpha(hslColor.getAlpha()).build();
    }

    @Deprecated
    public static EmbeddedSass.Value.RgbColor toRgbColor(Color color) {
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed(color.getRed()).setGreen(color.getGreen()).setBlue(color.getBlue()).setAlpha((double)color.getAlpha() / 255.0).build();
    }

    public static EmbeddedSass.Value.HslColor toHslColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        return ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hwbColor));
    }

    public static EmbeddedSass.Value.HslColor toHslColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        double red = (double)rgbColor.getRed() / 255.0;
        double green = (double)rgbColor.getGreen() / 255.0;
        double blue = (double)rgbColor.getBlue() / 255.0;
        double[] hsl = CssColorSpecUtil.rgbToHsl(red, green, blue);
        return EmbeddedSass.Value.HslColor.newBuilder().setHue(hsl[0]).setSaturation(hsl[1]).setLightness(hsl[2]).setAlpha(rgbColor.getAlpha()).build();
    }

    public static EmbeddedSass.Value.HwbColor toHwbColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        return ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hslColor));
    }

    public static EmbeddedSass.Value.HwbColor toHwbColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        double red = (double)rgbColor.getRed() / 255.0;
        double green = (double)rgbColor.getGreen() / 255.0;
        double blue = (double)rgbColor.getBlue() / 255.0;
        double[] hwb = CssColorSpecUtil.rgbToHwb(red, green, blue);
        return EmbeddedSass.Value.HwbColor.newBuilder().setHue(hwb[0]).setWhiteness(hwb[1]).setBlackness(hwb[2]).setAlpha(rgbColor.getAlpha()).build();
    }

    @Generated
    private ColorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

