/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import de.larsgrefer.sass.embedded.functions.ConversionService;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import de.larsgrefer.sass.embedded.functions.SassArgument;
import de.larsgrefer.sass.embedded.functions.SassFunction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import sass.embedded_protocol.EmbeddedSass;

class ReflectiveHostFunction
extends HostFunction {
    private final Method method;
    private final Object targetObject;

    public ReflectiveHostFunction(Method method) {
        this(method, null);
    }

    public ReflectiveHostFunction(Method method, Object targetObject) {
        super(ReflectiveHostFunction.resolveName(method), ReflectiveHostFunction.resolveArguments(method));
        this.method = method;
        if (Modifier.isStatic(method.getModifiers())) {
            this.targetObject = null;
        } else {
            if (targetObject == null) {
                throw new IllegalArgumentException("Calling the non-static method " + method + " requries a targetObject");
            }
            this.targetObject = Objects.requireNonNull(targetObject, () -> "Calling the non-static method " + method + " requires a targetObject");
        }
    }

    @Override
    public EmbeddedSass.Value invoke(List<EmbeddedSass.Value> arguments) throws Throwable {
        Object result;
        Object[] javaArgs = this.resolveArguments(arguments);
        try {
            result = this.method.invoke(this.targetObject, javaArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return ConversionService.toSassValue(result);
    }

    private Object[] resolveArguments(List<EmbeddedSass.Value> arguments) {
        if (this.method.getParameterCount() != arguments.size()) {
            throw new IllegalArgumentException("Invalid argument size");
        }
        Object[] result = new Object[arguments.size()];
        Parameter[] parameters = this.method.getParameters();
        for (int i = 0; i < arguments.size(); ++i) {
            Parameter parameter = parameters[i];
            Object o = ConversionService.toJavaValue(arguments.get(i), parameter.getType(), parameter.getParameterizedType());
            result[i] = o;
        }
        return result;
    }

    public static List<HostFunction.Argument> resolveArguments(Method method) {
        return Arrays.stream(method.getParameters()).map(ReflectiveHostFunction::toSassParam).collect(Collectors.toList());
    }

    private static HostFunction.Argument toSassParam(Parameter parameter) {
        HostFunction.Argument argument = new HostFunction.Argument(parameter.getName(), null);
        SassArgument sassArgument = parameter.getAnnotation(SassArgument.class);
        if (sassArgument != null) {
            if (!sassArgument.name().isEmpty()) {
                argument = argument.withName(sassArgument.name());
            }
            if (!sassArgument.defaultValue().isEmpty()) {
                argument.withDefaultValue(sassArgument.defaultValue());
            }
        }
        return argument;
    }

    private static String resolveName(Method method) {
        String name;
        SassFunction sassFunction = method.getAnnotation(SassFunction.class);
        if (sassFunction != null && !(name = sassFunction.name()).isEmpty()) {
            return name;
        }
        return method.getName();
    }
}

