///<reference path="definitions/external/tsd.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var WaitingPanel = /** @class */ (function () {
        function WaitingPanel(overlay) {
            this.overlay = overlay;
        }
        WaitingPanel.prototype.processAjaxUpdate = function () {
            var _this = this;
            var ajaxRequestsRunning = 0;
            return function (_a) {
                var status = _a.status;
                console.log("ButterFaces.WaitingPanel.onEvent - processEvent: " + status);
                if (status === "begin") {
                    ajaxRequestsRunning++;
                }
                else if (status === "success") {
                    ajaxRequestsRunning--;
                }
                if (ajaxRequestsRunning > 0) {
                    console.log("ButterFaces.WaitingPanel.onEvent  - show " + ajaxRequestsRunning);
                    _this.overlay.show();
                }
                else {
                    console.log("ButterFaces.WaitingPanel.onEvent  - hide " + ajaxRequestsRunning);
                    _this.overlay.hide();
                }
            };
        };
        WaitingPanel.prototype.processOnError = function (data) {
            if (data) {
                console.error("ButterFaces.WaitingPanel.onError  - An error occured, closing waiting panel. errorType: " + data.status + ", description: " + data.description);
                ButterFaces.Overlay.hideAll();
            }
        };
        return WaitingPanel;
    }());
    ButterFaces.WaitingPanel = WaitingPanel;
})(ButterFaces || (ButterFaces = {}));
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    var eventRegistered = false;
    var overlay;
    $.fn.waitingPanel = function (_a) {
        var waitingPanelDelay = _a.waitingPanelDelay, blockpage = _a.blockpage;
        return this.each(function () {
            // I found no way to remove event listener from jsf js.
            // I tried to register a callback once and change it on render waiting panel but after this
            // no waiting panel appears anymore.
            // Actually on each rendering of this component a new callback is put on event listener collection.
            if (!eventRegistered) {
                // console.log("waitingPanel - register: " + _elementId);
                overlay = new ButterFaces.Overlay(waitingPanelDelay, blockpage);
                var waitingPanel = new ButterFaces.WaitingPanel(overlay);
                jsf.ajax.addOnEvent(waitingPanel.processAjaxUpdate());
                jsf.ajax.addOnError(waitingPanel.processOnError);
                eventRegistered = true;
            }
            overlay.delay = waitingPanelDelay;
            overlay.isTransparentBlockingOverlayActive = blockpage;
        });
    };
}(jQuery));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
