///<reference path="definitions/external/tsd.d.ts"/>
///<reference path="butterfaces-guid.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Overlay = /** @class */ (function () {
        function Overlay(delay, isTransparentBlockingOverlayActive, selector) {
            if (delay === void 0) { delay = 500; }
            if (isTransparentBlockingOverlayActive === void 0) { isTransparentBlockingOverlayActive = true; }
            if (selector === void 0) { selector = "body"; }
            this.isHiding = true;
            this.delay = delay;
            this.isTransparentBlockingOverlayActive = isTransparentBlockingOverlayActive;
            this.selector = selector;
            console.log("ButterFaces.Overlay.constructor - creating overlay with delay is " + this.delay + ", isTransparentBlockingOverlayActive is " + this.isTransparentBlockingOverlayActive + ", selector is " + this.selector);
        }
        Overlay.prototype.show = function () {
            var _this = this;
            var $elementsToDisable = $(this.selector);
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                _this.isHiding = false;
                if (!ButterFaces.Object.isNullOrUndefined($elementToDisable.attr("data-overlay-uuid"))) {
                    if (ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid")).length > 0) {
                        console.log("ButterFaces.Overlay.show - overlay already existing. Skip showing overlay");
                        return;
                    }
                    else {
                        $elementToDisable.removeAttr("data-overlay-uuid");
                    }
                }
                console.log("ButterFaces.Overlay.show - appending not displayed overlay to body");
                var uuid = ButterFaces.Guid.newGuid();
                var $overlay = $("<div class='butter-component-overlay' data-overlay-uuid='" + uuid + "'><div class='butter-component-spinner'><div></div><div></div><div></div><div></div></div></div>");
                $elementToDisable.attr("data-overlay-uuid", uuid);
                if (_this.selector === "body") {
                    $overlay.addClass("overlay-body");
                }
                else {
                    // TODO if blockpage is true set it to max size
                    $overlay.offset($elementToDisable.offset())
                        .width($elementToDisable.outerWidth())
                        .height($elementToDisable.outerHeight())
                        .addClass("overlay-body-child")
                        .css({ "position": "absolute" }); // IE overrides css position so set it here
                }
                $("body").append($overlay);
                if (_this.isTransparentBlockingOverlayActive) {
                    console.log("ButterFaces.Overlay.show - isTransparentBlockingOverlayActive is true, showing transparent overlay direcly");
                    $overlay.show();
                }
                window.setTimeout(function () {
                    if (!_this.isHiding && !_this.isTransparentBlockingOverlayActive) {
                        console.log("ButterFaces.Overlay.show - deferred: isTransparentBlockingOverlayActive is false, showing transparent overlay after delay");
                        $overlay.show();
                    }
                    if (!_this.isHiding) {
                        console.log("ButterFaces.Overlay.show - deferred: starting animation to make overlay intransparent");
                        $overlay
                            .stop(true)
                            .animate({
                            opacity: 1
                        }, 300, function () {
                            console.log("ButterFaces.Overlay.show - deferred: animation ended to make overlay intransparent");
                        });
                    }
                }, _this.delay);
            });
        };
        Overlay.prototype.hide = function () {
            console.log("ButterFaces.Overlay.hide - starting animation to make overlay transparent");
            var $elementsToDisable = $(this.selector);
            this.isHiding = true;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                var overlayUuid = $elementToDisable.attr("data-overlay-uuid");
                if (!ButterFaces.Object.isNullOrUndefined(overlayUuid) && ButterFaces.Overlay.findOverlay(overlayUuid).length > 0) {
                    var $overlay = ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid"));
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.hideAll = function () {
            console.log("ButterFaces.Overlay.hideAll - starting animation to make all overlays transparent");
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            ButterFaces.Overlay.fadeOutAttachtedOverlays();
        };
        Overlay.fadeOutDetachtedOverlays = function () {
            // remove unbinded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                if ($("[data-overlay-uuid=" + uuidToCheck + "]").length === 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        ;
        Overlay.fadeOutAttachtedOverlays = function () {
            // remove binded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                var elements = $("[data-overlay-uuid=" + uuidToCheck + "]");
                if (elements.length > 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                    elements.each(function (index, element) {
                        var $element = $(element);
                        $element.removeAttr("data-overlay-uuid");
                    });
                }
            });
        };
        ;
        Overlay.fadeOutOverlay = function ($overlay) {
            $overlay
                .stop(true)
                .animate({
                opacity: 0
            }, 300, function () {
                $overlay.remove();
                console.log("ButterFaces.Overlay.hide - animation ended to make overlay transparent, OVERLAY REMOVED");
            });
        };
        ;
        Overlay.findOverlay = function (uuid) {
            return $("body .butter-component-overlay[data-overlay-uuid='" + uuid + "']");
        };
        return Overlay;
    }());
    ButterFaces.Overlay = Overlay;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJ1dHRlcmZhY2VzLW92ZXJsYXkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0RBQW9EO0FBQ3BELDBDQUEwQztBQUMxQyxpREFBaUQ7QUFFakQsSUFBVSxXQUFXLENBMEpwQjtBQTFKRCxXQUFVLFdBQVc7SUFFakI7UUFNSSxpQkFBWSxLQUFXLEVBQUUsa0NBQXlDLEVBQUUsUUFBcUI7WUFBN0Usc0JBQUEsRUFBQSxXQUFXO1lBQUUsbURBQUEsRUFBQSx5Q0FBeUM7WUFBRSx5QkFBQSxFQUFBLGlCQUFxQjtZQUNyRixJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztZQUNyQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztZQUNuQixJQUFJLENBQUMsa0NBQWtDLEdBQUcsa0NBQWtDLENBQUM7WUFDN0UsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7WUFFekIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtRUFBbUUsR0FBRyxJQUFJLENBQUMsS0FBSyxHQUFHLDBDQUEwQyxHQUFHLElBQUksQ0FBQyxrQ0FBa0MsR0FBRyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDNU4sQ0FBQztRQUVNLHNCQUFJLEdBQVg7WUFBQSxpQkFnRUM7WUEvREcsSUFBSSxrQkFBa0IsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBRTFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztZQUUvQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsVUFBQyxLQUFLLEVBQUUsZ0JBQWdCO2dCQUU1QyxJQUFJLGlCQUFpQixHQUFHLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO2dCQUU1QyxLQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztnQkFHdEIsRUFBRSxDQUFDLENBQUMsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNyRixFQUFFLENBQUMsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO3dCQUMxRixPQUFPLENBQUMsR0FBRyxDQUFDLDJFQUEyRSxDQUFDLENBQUM7d0JBQ3pGLE1BQU0sQ0FBQztvQkFDWCxDQUFDO29CQUFDLElBQUksQ0FBQyxDQUFDO3dCQUNKLGlCQUFpQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO29CQUN0RCxDQUFDO2dCQUNMLENBQUM7Z0JBRUQsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvRUFBb0UsQ0FBQyxDQUFDO2dCQUNsRixJQUFJLElBQUksR0FBRyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUV0QyxJQUFJLFFBQVEsR0FBRyxDQUFDLENBQUMsMkRBQTJELEdBQUcsSUFBSSxHQUFHLGtHQUFrRyxDQUFDLENBQUM7Z0JBRTFMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFFbEQsRUFBRSxDQUFDLENBQUMsS0FBSSxDQUFDLFFBQVEsS0FBSyxNQUFNLENBQUMsQ0FBQyxDQUFDO29CQUMzQixRQUFRLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxDQUFDO2dCQUN0QyxDQUFDO2dCQUFDLElBQUksQ0FBQyxDQUFDO29CQUNKLCtDQUErQztvQkFDL0MsUUFBUSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsQ0FBQzt5QkFDdEMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxDQUFDO3lCQUNyQyxNQUFNLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLENBQUM7eUJBQ3ZDLFFBQVEsQ0FBQyxvQkFBb0IsQ0FBQzt5QkFDOUIsR0FBRyxDQUFDLEVBQUMsVUFBVSxFQUFFLFVBQVUsRUFBQyxDQUFDLENBQUMsQ0FBQywyQ0FBMkM7Z0JBQ25GLENBQUM7Z0JBRUQsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQztnQkFFM0IsRUFBRSxDQUFDLENBQUMsS0FBSSxDQUFDLGtDQUFrQyxDQUFDLENBQUMsQ0FBQztvQkFDMUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyw0R0FBNEcsQ0FBQyxDQUFDO29CQUMxSCxRQUFRLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBQ3BCLENBQUM7Z0JBRUQsTUFBTSxDQUFDLFVBQVUsQ0FBQztvQkFDZCxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUksQ0FBQyxRQUFRLElBQUksQ0FBQyxLQUFJLENBQUMsa0NBQWtDLENBQUMsQ0FBQyxDQUFDO3dCQUM3RCxPQUFPLENBQUMsR0FBRyxDQUFDLDJIQUEySCxDQUFDLENBQUM7d0JBQ3pJLFFBQVEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztvQkFDcEIsQ0FBQztvQkFFRCxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO3dCQUNqQixPQUFPLENBQUMsR0FBRyxDQUFDLHVGQUF1RixDQUFDLENBQUM7d0JBQ3JHLFFBQVE7NkJBQ0gsSUFBSSxDQUFDLElBQUksQ0FBQzs2QkFDVixPQUFPLENBQUM7NEJBQ0wsT0FBTyxFQUFFLENBQUM7eUJBQ2IsRUFBRSxHQUFHLEVBQUU7NEJBQ0osT0FBTyxDQUFDLEdBQUcsQ0FBQyxvRkFBb0YsQ0FBQyxDQUFDO3dCQUN0RyxDQUFDLENBQUMsQ0FBQztvQkFDWCxDQUFDO2dCQUNMLENBQUMsRUFBRSxLQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDbkIsQ0FBQyxDQUFDLENBQUM7UUFDUCxDQUFDO1FBRU0sc0JBQUksR0FBWDtZQUNJLE9BQU8sQ0FBQyxHQUFHLENBQUMsMkVBQTJFLENBQUMsQ0FBQztZQUV6RixJQUFJLGtCQUFrQixHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7WUFDMUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7WUFFckIsV0FBVyxDQUFDLE9BQU8sQ0FBQyx3QkFBd0IsRUFBRSxDQUFDO1lBRS9DLGtCQUFrQixDQUFDLElBQUksQ0FBQyxVQUFDLEtBQUssRUFBRSxnQkFBZ0I7Z0JBQzVDLElBQUksaUJBQWlCLEdBQUcsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUM7Z0JBQzVDLElBQUksV0FBVyxHQUFHLGlCQUFpQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO2dCQUU5RCxFQUFFLENBQUMsQ0FBQyxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsaUJBQWlCLENBQUMsV0FBVyxDQUFDLElBQUksV0FBVyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ2hILElBQUksUUFBUSxHQUFHLFdBQVcsQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7b0JBRTVGLFdBQVcsQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO2dCQUNqRCxDQUFDO1lBRUwsQ0FBQyxDQUFDLENBQUM7UUFDUCxDQUFDO1FBRWEsZUFBTyxHQUFyQjtZQUNJLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUZBQW1GLENBQUMsQ0FBQztZQUVqRyxXQUFXLENBQUMsT0FBTyxDQUFDLHdCQUF3QixFQUFFLENBQUM7WUFDL0MsV0FBVyxDQUFDLE9BQU8sQ0FBQyx3QkFBd0IsRUFBRSxDQUFDO1FBQ25ELENBQUM7UUFFYyxnQ0FBd0IsR0FBdkM7WUFDSSwyQkFBMkI7WUFDM0IsQ0FBQyxDQUFDLDJCQUEyQixDQUFDLENBQUMsSUFBSSxDQUFDLFVBQUMsS0FBSyxFQUFFLGNBQWM7Z0JBQ3RELElBQUksUUFBUSxHQUFHLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQztnQkFDakMsSUFBSSxXQUFXLEdBQUcsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO2dCQUM5RCxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMscUJBQXFCLEdBQUcsV0FBVyxHQUFHLEdBQUcsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUM1RCxXQUFXLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxRQUFRLENBQUMsQ0FBQztnQkFDakQsQ0FBQztZQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQztRQUFBLENBQUM7UUFFYSxnQ0FBd0IsR0FBdkM7WUFDSSx5QkFBeUI7WUFDekIsQ0FBQyxDQUFDLDJCQUEyQixDQUFDLENBQUMsSUFBSSxDQUFDLFVBQUMsS0FBSyxFQUFFLGNBQWM7Z0JBQ3RELElBQUksUUFBUSxHQUFHLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQztnQkFDakMsSUFBSSxXQUFXLEdBQUcsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO2dCQUM5RCxJQUFJLFFBQVEsR0FBRyxDQUFDLENBQUMscUJBQXFCLEdBQUcsV0FBVyxHQUFHLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxFQUFFLENBQUMsQ0FBQyxRQUFRLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ3RCLFdBQVcsQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO29CQUU3QyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQUMsS0FBSyxFQUFFLE9BQU87d0JBQ3pCLElBQUksUUFBUSxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQzt3QkFDMUIsUUFBUSxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO29CQUM3QyxDQUFDLENBQUMsQ0FBQztnQkFDUCxDQUFDO1lBQ0wsQ0FBQyxDQUFDLENBQUM7UUFDUCxDQUFDO1FBQUEsQ0FBQztRQUVhLHNCQUFjLEdBQTdCLFVBQThCLFFBQWE7WUFDdkMsUUFBUTtpQkFDSCxJQUFJLENBQUMsSUFBSSxDQUFDO2lCQUNWLE9BQU8sQ0FBQztnQkFDTCxPQUFPLEVBQUUsQ0FBQzthQUNiLEVBQUUsR0FBRyxFQUFFO2dCQUNKLFFBQVEsQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDbEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyx5RkFBeUYsQ0FBQyxDQUFDO1lBQzNHLENBQUMsQ0FBQyxDQUFDO1FBQ1gsQ0FBQztRQUFBLENBQUM7UUFFYSxtQkFBVyxHQUExQixVQUEyQixJQUFZO1lBQ25DLE1BQU0sQ0FBQyxDQUFDLENBQUMsb0RBQW9ELEdBQUcsSUFBSSxHQUFHLElBQUksQ0FBQyxDQUFDO1FBQ2pGLENBQUM7UUFDTCxjQUFDO0lBQUQsQ0F2SkEsQUF1SkMsSUFBQTtJQXZKWSxtQkFBTyxVQXVKbkIsQ0FBQTtBQUNMLENBQUMsRUExSlMsV0FBVyxLQUFYLFdBQVcsUUEwSnBCIiwiZmlsZSI6ImJ1dHRlcmZhY2VzLW92ZXJsYXkuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvLy88cmVmZXJlbmNlIHBhdGg9XCJkZWZpbml0aW9ucy9leHRlcm5hbC90c2QuZC50c1wiLz5cbi8vLzxyZWZlcmVuY2UgcGF0aD1cImJ1dHRlcmZhY2VzLWd1aWQudHNcIi8+XG4vLy88cmVmZXJlbmNlIHBhdGg9XCJidXR0ZXJmYWNlcy11dGlsLW9iamVjdC50c1wiLz5cblxubmFtZXNwYWNlIEJ1dHRlckZhY2VzIHtcblxuICAgIGV4cG9ydCBjbGFzcyBPdmVybGF5IHtcbiAgICAgICAgaXNIaWRpbmc6IGJvb2xlYW47XG4gICAgICAgIGRlbGF5OiBudW1iZXI7XG4gICAgICAgIHNlbGVjdG9yOiBzdHJpbmc7XG4gICAgICAgIGlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmU6IGJvb2xlYW47XG5cbiAgICAgICAgY29uc3RydWN0b3IoZGVsYXkgPSA1MDAsIGlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmUgPSB0cnVlLCBzZWxlY3RvcjphbnkgPSBcImJvZHlcIikge1xuICAgICAgICAgICAgdGhpcy5pc0hpZGluZyA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLmRlbGF5ID0gZGVsYXk7XG4gICAgICAgICAgICB0aGlzLmlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmUgPSBpc1RyYW5zcGFyZW50QmxvY2tpbmdPdmVybGF5QWN0aXZlO1xuICAgICAgICAgICAgdGhpcy5zZWxlY3RvciA9IHNlbGVjdG9yO1xuXG4gICAgICAgICAgICBjb25zb2xlLmxvZyhcIkJ1dHRlckZhY2VzLk92ZXJsYXkuY29uc3RydWN0b3IgLSBjcmVhdGluZyBvdmVybGF5IHdpdGggZGVsYXkgaXMgXCIgKyB0aGlzLmRlbGF5ICsgXCIsIGlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmUgaXMgXCIgKyB0aGlzLmlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmUgKyBcIiwgc2VsZWN0b3IgaXMgXCIgKyB0aGlzLnNlbGVjdG9yKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHB1YmxpYyBzaG93KCkge1xuICAgICAgICAgICAgbGV0ICRlbGVtZW50c1RvRGlzYWJsZSA9ICQodGhpcy5zZWxlY3Rvcik7XG5cbiAgICAgICAgICAgIEJ1dHRlckZhY2VzLk92ZXJsYXkuZmFkZU91dERldGFjaHRlZE92ZXJsYXlzKCk7XG5cbiAgICAgICAgICAgICRlbGVtZW50c1RvRGlzYWJsZS5lYWNoKChpbmRleCwgZWxlbWVudFRvRGlzYWJsZSkgPT4ge1xuXG4gICAgICAgICAgICAgICAgbGV0ICRlbGVtZW50VG9EaXNhYmxlID0gJChlbGVtZW50VG9EaXNhYmxlKTtcblxuICAgICAgICAgICAgICAgIHRoaXMuaXNIaWRpbmcgPSBmYWxzZTtcblxuXG4gICAgICAgICAgICAgICAgaWYgKCFCdXR0ZXJGYWNlcy5PYmplY3QuaXNOdWxsT3JVbmRlZmluZWQoJGVsZW1lbnRUb0Rpc2FibGUuYXR0cihcImRhdGEtb3ZlcmxheS11dWlkXCIpKSkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoQnV0dGVyRmFjZXMuT3ZlcmxheS5maW5kT3ZlcmxheSgkZWxlbWVudFRvRGlzYWJsZS5hdHRyKFwiZGF0YS1vdmVybGF5LXV1aWRcIikpLmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKFwiQnV0dGVyRmFjZXMuT3ZlcmxheS5zaG93IC0gb3ZlcmxheSBhbHJlYWR5IGV4aXN0aW5nLiBTa2lwIHNob3dpbmcgb3ZlcmxheVwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICRlbGVtZW50VG9EaXNhYmxlLnJlbW92ZUF0dHIoXCJkYXRhLW92ZXJsYXktdXVpZFwiKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKFwiQnV0dGVyRmFjZXMuT3ZlcmxheS5zaG93IC0gYXBwZW5kaW5nIG5vdCBkaXNwbGF5ZWQgb3ZlcmxheSB0byBib2R5XCIpO1xuICAgICAgICAgICAgICAgIGxldCB1dWlkID0gQnV0dGVyRmFjZXMuR3VpZC5uZXdHdWlkKCk7XG5cbiAgICAgICAgICAgICAgICBsZXQgJG92ZXJsYXkgPSAkKFwiPGRpdiBjbGFzcz0nYnV0dGVyLWNvbXBvbmVudC1vdmVybGF5JyBkYXRhLW92ZXJsYXktdXVpZD0nXCIgKyB1dWlkICsgXCInPjxkaXYgY2xhc3M9J2J1dHRlci1jb21wb25lbnQtc3Bpbm5lcic+PGRpdj48L2Rpdj48ZGl2PjwvZGl2PjxkaXY+PC9kaXY+PGRpdj48L2Rpdj48L2Rpdj48L2Rpdj5cIik7XG5cbiAgICAgICAgICAgICAgICAkZWxlbWVudFRvRGlzYWJsZS5hdHRyKFwiZGF0YS1vdmVybGF5LXV1aWRcIiwgdXVpZCk7XG5cbiAgICAgICAgICAgICAgICBpZiAodGhpcy5zZWxlY3RvciA9PT0gXCJib2R5XCIpIHtcbiAgICAgICAgICAgICAgICAgICAgJG92ZXJsYXkuYWRkQ2xhc3MoXCJvdmVybGF5LWJvZHlcIik7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gVE9ETyBpZiBibG9ja3BhZ2UgaXMgdHJ1ZSBzZXQgaXQgdG8gbWF4IHNpemVcbiAgICAgICAgICAgICAgICAgICAgJG92ZXJsYXkub2Zmc2V0KCRlbGVtZW50VG9EaXNhYmxlLm9mZnNldCgpKVxuICAgICAgICAgICAgICAgICAgICAgICAgLndpZHRoKCRlbGVtZW50VG9EaXNhYmxlLm91dGVyV2lkdGgoKSlcbiAgICAgICAgICAgICAgICAgICAgICAgIC5oZWlnaHQoJGVsZW1lbnRUb0Rpc2FibGUub3V0ZXJIZWlnaHQoKSlcbiAgICAgICAgICAgICAgICAgICAgICAgIC5hZGRDbGFzcyhcIm92ZXJsYXktYm9keS1jaGlsZFwiKVxuICAgICAgICAgICAgICAgICAgICAgICAgLmNzcyh7XCJwb3NpdGlvblwiOiBcImFic29sdXRlXCJ9KTsgLy8gSUUgb3ZlcnJpZGVzIGNzcyBwb3NpdGlvbiBzbyBzZXQgaXQgaGVyZVxuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICQoXCJib2R5XCIpLmFwcGVuZCgkb3ZlcmxheSk7XG5cbiAgICAgICAgICAgICAgICBpZiAodGhpcy5pc1RyYW5zcGFyZW50QmxvY2tpbmdPdmVybGF5QWN0aXZlKSB7XG4gICAgICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKFwiQnV0dGVyRmFjZXMuT3ZlcmxheS5zaG93IC0gaXNUcmFuc3BhcmVudEJsb2NraW5nT3ZlcmxheUFjdGl2ZSBpcyB0cnVlLCBzaG93aW5nIHRyYW5zcGFyZW50IG92ZXJsYXkgZGlyZWNseVwiKTtcbiAgICAgICAgICAgICAgICAgICAgJG92ZXJsYXkuc2hvdygpO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHdpbmRvdy5zZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCF0aGlzLmlzSGlkaW5nICYmICF0aGlzLmlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKFwiQnV0dGVyRmFjZXMuT3ZlcmxheS5zaG93IC0gZGVmZXJyZWQ6IGlzVHJhbnNwYXJlbnRCbG9ja2luZ092ZXJsYXlBY3RpdmUgaXMgZmFsc2UsIHNob3dpbmcgdHJhbnNwYXJlbnQgb3ZlcmxheSBhZnRlciBkZWxheVwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICRvdmVybGF5LnNob3coKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgIGlmICghdGhpcy5pc0hpZGluZykge1xuICAgICAgICAgICAgICAgICAgICAgICAgY29uc29sZS5sb2coXCJCdXR0ZXJGYWNlcy5PdmVybGF5LnNob3cgLSBkZWZlcnJlZDogc3RhcnRpbmcgYW5pbWF0aW9uIHRvIG1ha2Ugb3ZlcmxheSBpbnRyYW5zcGFyZW50XCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgJG92ZXJsYXlcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAuc3RvcCh0cnVlKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIC5hbmltYXRlKHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgb3BhY2l0eTogMVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sIDMwMCwgKCkgPT4ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyhcIkJ1dHRlckZhY2VzLk92ZXJsYXkuc2hvdyAtIGRlZmVycmVkOiBhbmltYXRpb24gZW5kZWQgdG8gbWFrZSBvdmVybGF5IGludHJhbnNwYXJlbnRcIik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9LCB0aGlzLmRlbGF5KTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9XG5cbiAgICAgICAgcHVibGljIGhpZGUoKSB7XG4gICAgICAgICAgICBjb25zb2xlLmxvZyhcIkJ1dHRlckZhY2VzLk92ZXJsYXkuaGlkZSAtIHN0YXJ0aW5nIGFuaW1hdGlvbiB0byBtYWtlIG92ZXJsYXkgdHJhbnNwYXJlbnRcIik7XG5cbiAgICAgICAgICAgIGxldCAkZWxlbWVudHNUb0Rpc2FibGUgPSAkKHRoaXMuc2VsZWN0b3IpO1xuICAgICAgICAgICAgdGhpcy5pc0hpZGluZyA9IHRydWU7XG5cbiAgICAgICAgICAgIEJ1dHRlckZhY2VzLk92ZXJsYXkuZmFkZU91dERldGFjaHRlZE92ZXJsYXlzKCk7XG5cbiAgICAgICAgICAgICRlbGVtZW50c1RvRGlzYWJsZS5lYWNoKChpbmRleCwgZWxlbWVudFRvRGlzYWJsZSkgPT4ge1xuICAgICAgICAgICAgICAgIGxldCAkZWxlbWVudFRvRGlzYWJsZSA9ICQoZWxlbWVudFRvRGlzYWJsZSk7XG4gICAgICAgICAgICAgICAgbGV0IG92ZXJsYXlVdWlkID0gJGVsZW1lbnRUb0Rpc2FibGUuYXR0cihcImRhdGEtb3ZlcmxheS11dWlkXCIpO1xuXG4gICAgICAgICAgICAgICAgaWYgKCFCdXR0ZXJGYWNlcy5PYmplY3QuaXNOdWxsT3JVbmRlZmluZWQob3ZlcmxheVV1aWQpICYmIEJ1dHRlckZhY2VzLk92ZXJsYXkuZmluZE92ZXJsYXkob3ZlcmxheVV1aWQpLmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgICAgICAgICAgbGV0ICRvdmVybGF5ID0gQnV0dGVyRmFjZXMuT3ZlcmxheS5maW5kT3ZlcmxheSgkZWxlbWVudFRvRGlzYWJsZS5hdHRyKFwiZGF0YS1vdmVybGF5LXV1aWRcIikpO1xuXG4gICAgICAgICAgICAgICAgICAgIEJ1dHRlckZhY2VzLk92ZXJsYXkuZmFkZU91dE92ZXJsYXkoJG92ZXJsYXkpO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH1cblxuICAgICAgICBwdWJsaWMgc3RhdGljIGhpZGVBbGwoKSB7XG4gICAgICAgICAgICBjb25zb2xlLmxvZyhcIkJ1dHRlckZhY2VzLk92ZXJsYXkuaGlkZUFsbCAtIHN0YXJ0aW5nIGFuaW1hdGlvbiB0byBtYWtlIGFsbCBvdmVybGF5cyB0cmFuc3BhcmVudFwiKTtcblxuICAgICAgICAgICAgQnV0dGVyRmFjZXMuT3ZlcmxheS5mYWRlT3V0RGV0YWNodGVkT3ZlcmxheXMoKTtcbiAgICAgICAgICAgIEJ1dHRlckZhY2VzLk92ZXJsYXkuZmFkZU91dEF0dGFjaHRlZE92ZXJsYXlzKCk7XG4gICAgICAgIH1cblxuICAgICAgICBwcml2YXRlIHN0YXRpYyBmYWRlT3V0RGV0YWNodGVkT3ZlcmxheXMoKSB7XG4gICAgICAgICAgICAvLyByZW1vdmUgdW5iaW5kZWQgZWxlbWVudHNcbiAgICAgICAgICAgICQoXCIuYnV0dGVyLWNvbXBvbmVudC1vdmVybGF5XCIpLmVhY2goKGluZGV4LCBlbGVtZW50VG9DaGVjaykgPT4ge1xuICAgICAgICAgICAgICAgIGxldCAkb3ZlcmxheSA9ICQoZWxlbWVudFRvQ2hlY2spO1xuICAgICAgICAgICAgICAgIGxldCB1dWlkVG9DaGVjayA9ICQoZWxlbWVudFRvQ2hlY2spLmF0dHIoXCJkYXRhLW92ZXJsYXktdXVpZFwiKTtcbiAgICAgICAgICAgICAgICBpZiAoJChcIltkYXRhLW92ZXJsYXktdXVpZD1cIiArIHV1aWRUb0NoZWNrICsgXCJdXCIpLmxlbmd0aCA9PT0gMSkge1xuICAgICAgICAgICAgICAgICAgICBCdXR0ZXJGYWNlcy5PdmVybGF5LmZhZGVPdXRPdmVybGF5KCRvdmVybGF5KTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfTtcblxuICAgICAgICBwcml2YXRlIHN0YXRpYyBmYWRlT3V0QXR0YWNodGVkT3ZlcmxheXMoKSB7XG4gICAgICAgICAgICAvLyByZW1vdmUgYmluZGVkIGVsZW1lbnRzXG4gICAgICAgICAgICAkKFwiLmJ1dHRlci1jb21wb25lbnQtb3ZlcmxheVwiKS5lYWNoKChpbmRleCwgZWxlbWVudFRvQ2hlY2spID0+IHtcbiAgICAgICAgICAgICAgICBsZXQgJG92ZXJsYXkgPSAkKGVsZW1lbnRUb0NoZWNrKTtcbiAgICAgICAgICAgICAgICBsZXQgdXVpZFRvQ2hlY2sgPSAkKGVsZW1lbnRUb0NoZWNrKS5hdHRyKFwiZGF0YS1vdmVybGF5LXV1aWRcIik7XG4gICAgICAgICAgICAgICAgbGV0IGVsZW1lbnRzID0gJChcIltkYXRhLW92ZXJsYXktdXVpZD1cIiArIHV1aWRUb0NoZWNrICsgXCJdXCIpO1xuICAgICAgICAgICAgICAgIGlmIChlbGVtZW50cy5sZW5ndGggPiAxKSB7XG4gICAgICAgICAgICAgICAgICAgIEJ1dHRlckZhY2VzLk92ZXJsYXkuZmFkZU91dE92ZXJsYXkoJG92ZXJsYXkpO1xuXG4gICAgICAgICAgICAgICAgICAgIGVsZW1lbnRzLmVhY2goKGluZGV4LCBlbGVtZW50KSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgJGVsZW1lbnQgPSAkKGVsZW1lbnQpO1xuICAgICAgICAgICAgICAgICAgICAgICAgJGVsZW1lbnQucmVtb3ZlQXR0cihcImRhdGEtb3ZlcmxheS11dWlkXCIpO1xuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfTtcblxuICAgICAgICBwcml2YXRlIHN0YXRpYyBmYWRlT3V0T3ZlcmxheSgkb3ZlcmxheTogYW55KSB7XG4gICAgICAgICAgICAkb3ZlcmxheVxuICAgICAgICAgICAgICAgIC5zdG9wKHRydWUpXG4gICAgICAgICAgICAgICAgLmFuaW1hdGUoe1xuICAgICAgICAgICAgICAgICAgICBvcGFjaXR5OiAwXG4gICAgICAgICAgICAgICAgfSwgMzAwLCAoKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICRvdmVybGF5LnJlbW92ZSgpO1xuICAgICAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyhcIkJ1dHRlckZhY2VzLk92ZXJsYXkuaGlkZSAtIGFuaW1hdGlvbiBlbmRlZCB0byBtYWtlIG92ZXJsYXkgdHJhbnNwYXJlbnQsIE9WRVJMQVkgUkVNT1ZFRFwiKTtcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgfTtcblxuICAgICAgICBwcml2YXRlIHN0YXRpYyBmaW5kT3ZlcmxheSh1dWlkOiBTdHJpbmcpIHtcbiAgICAgICAgICAgIHJldHVybiAkKFwiYm9keSAuYnV0dGVyLWNvbXBvbmVudC1vdmVybGF5W2RhdGEtb3ZlcmxheS11dWlkPSdcIiArIHV1aWQgKyBcIiddXCIpO1xuICAgICAgICB9XG4gICAgfVxufSJdfQ==
