///<reference path="definitions/external/jquery/jquery.d.ts"/>
///<reference path="butterfaces-util-string.ts"/>
///<reference path="butterfaces-util-object.ts"/>
(function ($) {
    $.fn.butterMaxLength = function (maxLength, maxLengthText) {
        var ERROR_STYLE_CLASS = "has-error";
        return this.each(function () {
            // console.log("initializing max length");
            var $root = $(this);
            var $valueElement = $root.find("textarea");
            var $maxLength = $root.find(".butter-component-maxlength-counter");
            if ($maxLength.length > 0) {
                // console.log("found max length element");
                var hasInitialValidationError_1 = $root.hasClass(ERROR_STYLE_CLASS);
                var _checkValue = function () {
                    var value = $valueElement.val();
                    // console.log("checking value");
                    // console.log(value);
                    if (!ButterFaces.Object.isNullOrUndefined(value)) {
                        var freeLetterCount = maxLength - value.length;
                        var formatted = ButterFaces.String.format(maxLengthText, [freeLetterCount, maxLength]);
                        $maxLength.text(formatted);
                        if (!hasInitialValidationError_1) {
                            if (freeLetterCount < 0) {
                                $root.addClass(ERROR_STYLE_CLASS);
                            }
                            else {
                                $root.removeClass(ERROR_STYLE_CLASS);
                            }
                        }
                    }
                };
                $valueElement.on("focus blur keyup cut paste", _checkValue);
                // initial check
                _checkValue();
            }
        });
    };
}(jQuery));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
