///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var CommandLink = /** @class */ (function () {
        function CommandLink() {
        }
        /**
         * Submit given form.
         * @param formId the target form id to submit
         * @param params a list of params to be added to form as hidden input fields
         * @param target the target of the form submission
         */
        CommandLink.submitForm = function (formId, params, target) {
            var form = document.getElementById(formId);
            ButterFaces.CommandLink.addParametersAsHiddenFieldsToForm(form, params);
            var oldFormTarget = ButterFaces.CommandLink.setFormTarget(form, target);
            if (form.onsubmit) {
                var result = form.onsubmit();
                if (ButterFaces.Object.isNullOrUndefined(result) || result) {
                    form.submit();
                }
            }
            else {
                form.submit();
            }
            form.target = oldFormTarget;
            ButterFaces.CommandLink.removeHiddenFieldsFromForm(form);
        };
        CommandLink.addParametersAsHiddenFieldsToForm = function (form, params) {
            var bfHiddenInputFields = new Array();
            form.bfHiddenInputFields = bfHiddenInputFields;
            var i = 0;
            for (var k in params) {
                if (params.hasOwnProperty(k)) {
                    var p = document.createElement("input");
                    p.type = "hidden";
                    p.name = k;
                    p.value = params[k];
                    form.appendChild(p);
                    bfHiddenInputFields[i++] = p;
                }
            }
        };
        CommandLink.removeHiddenFieldsFromForm = function (form) {
            var bfHiddenInputFields = form.bfHiddenInputFields;
            if (bfHiddenInputFields !== null) {
                for (var i = 0; i < bfHiddenInputFields.length; i++) {
                    form.removeChild(bfHiddenInputFields[i]);
                }
            }
        };
        /**
         * Updates form target (if exists) and returns previous form target
         * @param form the torm to add the new target to
         * @param target the target to add (if not null)
         * @return the previous form target
         */
        CommandLink.setFormTarget = function (form, target) {
            var previousTarget = form.target;
            if (target) {
                form.target = target;
            }
            return previousTarget;
        };
        return CommandLink;
    }());
    ButterFaces.CommandLink = CommandLink;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJ1dHRlcmZhY2VzLWxpbmsudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsaURBQWlEO0FBRWpELElBQVUsV0FBVyxDQXVFcEI7QUF2RUQsV0FBVSxXQUFXO0lBQ2pCO1FBQUE7UUFxRUEsQ0FBQztRQW5FRzs7Ozs7V0FLRztRQUNJLHNCQUFVLEdBQWpCLFVBQWtCLE1BQWMsRUFBRSxNQUFXLEVBQUUsTUFBYztZQUN6RCxJQUFJLElBQUksR0FBUSxRQUFRLENBQUMsY0FBYyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBRWhELFdBQVcsQ0FBQyxXQUFXLENBQUMsaUNBQWlDLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1lBQ3hFLElBQUksYUFBYSxHQUFHLFdBQVcsQ0FBQyxXQUFXLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQztZQUV4RSxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztnQkFDaEIsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO2dCQUM3QixFQUFFLENBQUMsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxDQUFDLENBQUM7b0JBQ3pELElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDbEIsQ0FBQztZQUNMLENBQUM7WUFBQyxJQUFJLENBQUMsQ0FBQztnQkFDSixJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDbEIsQ0FBQztZQUVELElBQUksQ0FBQyxNQUFNLEdBQUcsYUFBYSxDQUFDO1lBQzVCLFdBQVcsQ0FBQyxXQUFXLENBQUMsMEJBQTBCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0QsQ0FBQztRQUVjLDZDQUFpQyxHQUFoRCxVQUFpRCxJQUFTLEVBQUUsTUFBVztZQUNuRSxJQUFJLG1CQUFtQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLG1CQUFtQixDQUFDO1lBRS9DLElBQUksQ0FBQyxHQUFXLENBQUMsQ0FBQztZQUVsQixHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxNQUFNLENBQUMsQ0FBQyxDQUFDO2dCQUNuQixFQUFFLENBQUMsQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDM0IsSUFBSSxDQUFDLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztvQkFDeEMsQ0FBQyxDQUFDLElBQUksR0FBRyxRQUFRLENBQUM7b0JBQ2xCLENBQUMsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDO29CQUNYLENBQUMsQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNwQixJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNwQixtQkFBbUIsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDakMsQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO1FBRWMsc0NBQTBCLEdBQXpDLFVBQTBDLElBQVM7WUFDL0MsSUFBSSxtQkFBbUIsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7WUFDbkQsRUFBRSxDQUFDLENBQUMsbUJBQW1CLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQztnQkFDL0IsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxtQkFBbUIsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztvQkFDbEQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUM3QyxDQUFDO1lBQ0wsQ0FBQztRQUNMLENBQUM7UUFFRDs7Ozs7V0FLRztRQUNZLHlCQUFhLEdBQTVCLFVBQTZCLElBQVMsRUFBRSxNQUFjO1lBQ2xELElBQUksY0FBYyxHQUFXLElBQUksQ0FBQyxNQUFNLENBQUM7WUFFekMsRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztnQkFDVCxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztZQUN6QixDQUFDO1lBRUQsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUMxQixDQUFDO1FBQ0wsa0JBQUM7SUFBRCxDQXJFQSxBQXFFQyxJQUFBO0lBckVZLHVCQUFXLGNBcUV2QixDQUFBO0FBQ0wsQ0FBQyxFQXZFUyxXQUFXLEtBQVgsV0FBVyxRQXVFcEIiLCJmaWxlIjoiYnV0dGVyZmFjZXMtbGluay5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8vLzxyZWZlcmVuY2UgcGF0aD1cImJ1dHRlcmZhY2VzLXV0aWwtb2JqZWN0LnRzXCIvPlxuXG5uYW1lc3BhY2UgQnV0dGVyRmFjZXMge1xuICAgIGV4cG9ydCBjbGFzcyBDb21tYW5kTGluayB7XG5cbiAgICAgICAgLyoqXG4gICAgICAgICAqIFN1Ym1pdCBnaXZlbiBmb3JtLlxuICAgICAgICAgKiBAcGFyYW0gZm9ybUlkIHRoZSB0YXJnZXQgZm9ybSBpZCB0byBzdWJtaXRcbiAgICAgICAgICogQHBhcmFtIHBhcmFtcyBhIGxpc3Qgb2YgcGFyYW1zIHRvIGJlIGFkZGVkIHRvIGZvcm0gYXMgaGlkZGVuIGlucHV0IGZpZWxkc1xuICAgICAgICAgKiBAcGFyYW0gdGFyZ2V0IHRoZSB0YXJnZXQgb2YgdGhlIGZvcm0gc3VibWlzc2lvblxuICAgICAgICAgKi9cbiAgICAgICAgc3RhdGljIHN1Ym1pdEZvcm0oZm9ybUlkOiBzdHJpbmcsIHBhcmFtczogYW55LCB0YXJnZXQ6IHN0cmluZykge1xuICAgICAgICAgICAgbGV0IGZvcm06IGFueSA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKGZvcm1JZCk7XG5cbiAgICAgICAgICAgIEJ1dHRlckZhY2VzLkNvbW1hbmRMaW5rLmFkZFBhcmFtZXRlcnNBc0hpZGRlbkZpZWxkc1RvRm9ybShmb3JtLCBwYXJhbXMpO1xuICAgICAgICAgICAgbGV0IG9sZEZvcm1UYXJnZXQgPSBCdXR0ZXJGYWNlcy5Db21tYW5kTGluay5zZXRGb3JtVGFyZ2V0KGZvcm0sIHRhcmdldCk7XG5cbiAgICAgICAgICAgIGlmIChmb3JtLm9uc3VibWl0KSB7XG4gICAgICAgICAgICAgICAgbGV0IHJlc3VsdCA9IGZvcm0ub25zdWJtaXQoKTtcbiAgICAgICAgICAgICAgICBpZiAoQnV0dGVyRmFjZXMuT2JqZWN0LmlzTnVsbE9yVW5kZWZpbmVkKHJlc3VsdCkgfHwgcmVzdWx0KSB7XG4gICAgICAgICAgICAgICAgICAgIGZvcm0uc3VibWl0KCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBmb3JtLnN1Ym1pdCgpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBmb3JtLnRhcmdldCA9IG9sZEZvcm1UYXJnZXQ7XG4gICAgICAgICAgICBCdXR0ZXJGYWNlcy5Db21tYW5kTGluay5yZW1vdmVIaWRkZW5GaWVsZHNGcm9tRm9ybShmb3JtKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHByaXZhdGUgc3RhdGljIGFkZFBhcmFtZXRlcnNBc0hpZGRlbkZpZWxkc1RvRm9ybShmb3JtOiBhbnksIHBhcmFtczogYW55KSB7XG4gICAgICAgICAgICBsZXQgYmZIaWRkZW5JbnB1dEZpZWxkcyA9IG5ldyBBcnJheSgpO1xuICAgICAgICAgICAgZm9ybS5iZkhpZGRlbklucHV0RmllbGRzID0gYmZIaWRkZW5JbnB1dEZpZWxkcztcblxuICAgICAgICAgICAgbGV0IGk6IG51bWJlciA9IDA7XG5cbiAgICAgICAgICAgIGZvciAobGV0IGsgaW4gcGFyYW1zKSB7XG4gICAgICAgICAgICAgICAgaWYgKHBhcmFtcy5oYXNPd25Qcm9wZXJ0eShrKSkge1xuICAgICAgICAgICAgICAgICAgICBsZXQgcCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoXCJpbnB1dFwiKTtcbiAgICAgICAgICAgICAgICAgICAgcC50eXBlID0gXCJoaWRkZW5cIjtcbiAgICAgICAgICAgICAgICAgICAgcC5uYW1lID0gaztcbiAgICAgICAgICAgICAgICAgICAgcC52YWx1ZSA9IHBhcmFtc1trXTtcbiAgICAgICAgICAgICAgICAgICAgZm9ybS5hcHBlbmRDaGlsZChwKTtcbiAgICAgICAgICAgICAgICAgICAgYmZIaWRkZW5JbnB1dEZpZWxkc1tpKytdID0gcDtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBwcml2YXRlIHN0YXRpYyByZW1vdmVIaWRkZW5GaWVsZHNGcm9tRm9ybShmb3JtOiBhbnkpIHtcbiAgICAgICAgICAgIGxldCBiZkhpZGRlbklucHV0RmllbGRzID0gZm9ybS5iZkhpZGRlbklucHV0RmllbGRzO1xuICAgICAgICAgICAgaWYgKGJmSGlkZGVuSW5wdXRGaWVsZHMgIT09IG51bGwpIHtcbiAgICAgICAgICAgICAgICBmb3IgKGxldCBpID0gMDsgaSA8IGJmSGlkZGVuSW5wdXRGaWVsZHMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICAgICAgICAgICAgZm9ybS5yZW1vdmVDaGlsZChiZkhpZGRlbklucHV0RmllbGRzW2ldKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICAvKipcbiAgICAgICAgICogVXBkYXRlcyBmb3JtIHRhcmdldCAoaWYgZXhpc3RzKSBhbmQgcmV0dXJucyBwcmV2aW91cyBmb3JtIHRhcmdldFxuICAgICAgICAgKiBAcGFyYW0gZm9ybSB0aGUgdG9ybSB0byBhZGQgdGhlIG5ldyB0YXJnZXQgdG9cbiAgICAgICAgICogQHBhcmFtIHRhcmdldCB0aGUgdGFyZ2V0IHRvIGFkZCAoaWYgbm90IG51bGwpXG4gICAgICAgICAqIEByZXR1cm4gdGhlIHByZXZpb3VzIGZvcm0gdGFyZ2V0XG4gICAgICAgICAqL1xuICAgICAgICBwcml2YXRlIHN0YXRpYyBzZXRGb3JtVGFyZ2V0KGZvcm06IGFueSwgdGFyZ2V0OiBzdHJpbmcpOiBzdHJpbmcge1xuICAgICAgICAgICAgbGV0IHByZXZpb3VzVGFyZ2V0OiBzdHJpbmcgPSBmb3JtLnRhcmdldDtcblxuICAgICAgICAgICAgaWYgKHRhcmdldCkge1xuICAgICAgICAgICAgICAgIGZvcm0udGFyZ2V0ID0gdGFyZ2V0O1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICByZXR1cm4gcHJldmlvdXNUYXJnZXQ7XG4gICAgICAgIH1cbiAgICB9XG59Il19
