/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.util;

import de.larmic.butterfaces.util.StringJoiner;
import java.util.Collection;

public class StringUtils {
    public static final String BLANK = "";
    public static final String SPACE = " ";
    public static final String SEPARATOR_COMMA = ", ";

    @Deprecated
    public static String concatWithSpace(String ... styles) {
        StringBuilder sb = new StringBuilder();
        for (String style : styles) {
            if (style == null || BLANK.equals(style)) continue;
            sb.append(style);
            sb.append(SPACE);
        }
        return sb.toString().trim();
    }

    public static boolean isEmpty(String value) {
        return value == null || BLANK.equals(value);
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static String getNotNullValue(String value, String alternative) {
        return StringUtils.isNotEmpty(value) ? value : alternative;
    }

    public static String getNullSafeValue(String value) {
        return StringUtils.getNotNullValue(value, BLANK);
    }

    @Deprecated
    public static String joinWithCommaSeparator(Collection<String> values) {
        return StringJoiner.on(SEPARATOR_COMMA).join(values).toString();
    }

    @Deprecated
    public static String joinWithCommaSeparator(Collection<String> values, boolean escape) {
        return StringJoiner.on(SEPARATOR_COMMA).join(values).wrappedBy("'").toString();
    }

    @Deprecated
    public static String joinWithSpaceSeparator(Collection<String> values) {
        return StringJoiner.on(SPACE).join(values).toString();
    }
}

