/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.resolver;

import de.larmic.butterfaces.resolver.VisitContextImpl;
import de.larmic.butterfaces.util.StringUtils;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

public class UIComponentResolver {
    public static String getFormClientId(UIComponent component, FacesContext context) {
        UIForm form = UIComponentResolver.getForm(component);
        return form != null ? form.getClientId(context) : null;
    }

    public static UIForm getForm(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm form = (UIForm)parent;
        if (form != null) {
            return form;
        }
        return null;
    }

    public String findComponentsClientId(String id) {
        if (id.contains(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()) + "")) {
            return id;
        }
        UIComponent component = this.findComponent(id);
        return component != null ? component.getClientId() : id;
    }

    public UIComponent findComponent(String id) {
        return this.findComponent(id, null);
    }

    public <T extends UIComponent> T findComponent(String id, final Class<T> componentClass) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot root = context.getViewRoot();
        final UIComponent[] found = new UIComponent[1];
        final String clientId = this.checkClientId(context, id);
        root.visitTree((VisitContext)new VisitContextImpl(context), new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent component) {
                if (clientId.equals(component.getId()) && (componentClass == null || component.getClass().equals(componentClass))) {
                    found[0] = component;
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return (T)found[0];
    }

    private String checkClientId(FacesContext context, String clientId) {
        return StringUtils.isNotEmpty(clientId) && clientId.charAt(0) == UINamingContainer.getSeparatorChar((FacesContext)context) ? clientId.substring(1) : clientId;
    }
}

