/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.resolver;

import de.larmic.butterfaces.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;

public class AjaxClientIdResolver {
    private final Set<String> ajaxRenderClientIds = new HashSet<String>();
    private final Set<String> resolvedAjaxRenderClientIds = new HashSet<String>();
    private final Set<String> resolvedAjaxRenderJQueryClientIds = new HashSet<String>();
    private final String jQueryRenderIDSelector;

    public AjaxClientIdResolver(UIComponent component) {
        if (!(component instanceof ClientBehaviorHolder)) {
            throw new IllegalArgumentException("Component " + component.getClass() + " is not implementing ClientBehaviorHolder");
        }
        this.ajaxRenderClientIds.addAll(this.findClientIdsToDisableOnRequest((ClientBehaviorHolder)component));
        this.resolvedAjaxRenderClientIds.addAll(this.resolveClientIds(component, this.ajaxRenderClientIds));
        this.resolvedAjaxRenderJQueryClientIds.addAll(this.convertClientIdsToJQuerySelectorIds(this.resolvedAjaxRenderClientIds));
        this.jQueryRenderIDSelector = this.createJQueryIDSelector(this.resolvedAjaxRenderJQueryClientIds, component);
    }

    private String createJQueryIDSelector(Collection<String> jQueryReadableClientIds, UIComponent component) {
        if (null == jQueryReadableClientIds || jQueryReadableClientIds.isEmpty()) {
            return "undefined";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = jQueryReadableClientIds.iterator();
        while (iterator.hasNext()) {
            String jQueryReadableClientId = iterator.next();
            if (jQueryReadableClientId.equals("@all")) {
                builder.append("html");
            } else if (jQueryReadableClientId.equals("@form")) {
                String clientIdOfSurroundingFormClientId = this.findClientIdOfSurroundingFormClientId(component);
                if (StringUtils.isNotEmpty(clientIdOfSurroundingFormClientId)) {
                    builder.append("#" + clientIdOfSurroundingFormClientId);
                }
            } else if (!jQueryReadableClientId.equals("@this") && !jQueryReadableClientId.equals("@none")) {
                builder.append(jQueryReadableClientId);
            }
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private Set<String> findClientIdsToDisableOnRequest(ClientBehaviorHolder clientBehaviorHolder) {
        HashSet<String> renderClientIds = new HashSet<String>();
        if (!clientBehaviorHolder.getClientBehaviors().isEmpty()) {
            Collection clientBehaviors = clientBehaviorHolder.getClientBehaviors().values();
            for (List clientBehavior : clientBehaviors) {
                for (ClientBehavior behavior : clientBehavior) {
                    if (!(behavior instanceof AjaxBehavior)) continue;
                    AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
                    for (String render : ajaxBehavior.getRender()) {
                        if (!StringUtils.isNotEmpty(render)) continue;
                        renderClientIds.add(render.trim());
                    }
                }
            }
        }
        return renderClientIds;
    }

    private Set<String> convertClientIdsToJQuerySelectorIds(Collection<String> clientIds) {
        HashSet<String> jQueryClientIds = new HashSet<String>();
        for (String clientIdToConvert : clientIds) {
            if (clientIdToConvert.startsWith("@")) {
                jQueryClientIds.add(clientIdToConvert);
                continue;
            }
            jQueryClientIds.add("#" + clientIdToConvert.replaceAll(":", "\\\\\\\\:"));
        }
        return jQueryClientIds;
    }

    private Set<String> resolveClientIds(UIComponent component, Collection<String> clientIdsToResolve) {
        HashSet<String> resolvedClientIds = new HashSet<String>();
        if (null == clientIdsToResolve || clientIdsToResolve.isEmpty()) {
            return resolvedClientIds;
        }
        for (String clientIdToResolve : clientIdsToResolve) {
            if (clientIdToResolve.trim().length() == 0) continue;
            if (clientIdToResolve.equals("@all") || clientIdToResolve.equals("@none") || clientIdToResolve.equals("@form") || clientIdToResolve.equals("@this")) {
                resolvedClientIds.add(clientIdToResolve);
                continue;
            }
            resolvedClientIds.add(this.getResolvedId(component, clientIdToResolve));
        }
        return resolvedClientIds;
    }

    private String getResolvedId(UIComponent component, String clientIdToResolve) {
        UIComponent resolvedComponent = this.resolveComponent(component, clientIdToResolve);
        if (resolvedComponent == null) {
            if (clientIdToResolve.charAt(0) == UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance())) {
                return clientIdToResolve.substring(1);
            }
            return clientIdToResolve;
        }
        return resolvedComponent.getClientId();
    }

    private UIComponent resolveComponent(UIComponent component, String clientIdToResolve) {
        if (component == null) {
            return null;
        }
        UIComponent resolvedComponent = component.findComponent(clientIdToResolve);
        return resolvedComponent != null ? resolvedComponent : this.resolveComponent(component.getParent(), clientIdToResolve);
    }

    private String findClientIdOfSurroundingFormClientId(UIComponent component) {
        if (component instanceof HtmlForm) {
            return component.getClientId();
        }
        if (component.getParent() == null) {
            return null;
        }
        return this.findClientIdOfSurroundingFormClientId(component.getParent());
    }

    public Set<String> getResolvedAjaxRenderClientIds() {
        return this.resolvedAjaxRenderClientIds;
    }

    public Set<String> getAjaxRenderClientIds() {
        return this.ajaxRenderClientIds;
    }

    public Set<String> getResolvedAjaxRenderJQueryClientIds() {
        return this.resolvedAjaxRenderJQueryClientIds;
    }

    public String getjQueryRenderIDSelector() {
        return this.jQueryRenderIDSelector;
    }
}

