/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.text.util;

import de.larmic.butterfaces.context.StringHtmlEncoder;
import de.larmic.butterfaces.resolver.MustacheResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

public class TrivialComponentsUtil {
    public static List<String> replaceDotInMustacheKeys(List<String> mustacheKeys) {
        ArrayList<String> fixedMustacheKeys = new ArrayList<String>();
        for (String mustacheKey : mustacheKeys) {
            fixedMustacheKeys.add(mustacheKey.replace('.', '#'));
        }
        return fixedMustacheKeys;
    }

    public static String replaceDotInMustacheKeys(List<String> mustacheKeys, String pluginCall) {
        String fixedPluginCall = pluginCall;
        for (String mustacheKey : mustacheKeys) {
            if (!mustacheKey.contains(".")) continue;
            fixedPluginCall = fixedPluginCall.replace("{{" + mustacheKey + "}}", "{{" + mustacheKey.replace('.', '#') + "}}");
        }
        return fixedPluginCall;
    }

    public static List<String> createMustacheKeys(FacesContext context, UIComponentBase component) throws IOException {
        HashSet<String> mustacheKeys = new HashSet<String>();
        mustacheKeys.addAll(TrivialComponentsUtil.createMustacheKeysFromTemplate(context, component, "template"));
        mustacheKeys.addAll(TrivialComponentsUtil.createMustacheKeysFromTemplate(context, component, "emptyEntryTemplate"));
        mustacheKeys.addAll(TrivialComponentsUtil.createMustacheKeysFromTemplate(context, component, "selectedEntryTemplate"));
        return new ArrayList<String>(mustacheKeys);
    }

    private static List<String> createMustacheKeysFromTemplate(FacesContext context, UIComponentBase component, String facetKey) throws IOException {
        UIComponent templateFacet = component.getFacet(facetKey);
        if (templateFacet != null) {
            String encodedTemplate = StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, templateFacet);
            return MustacheResolver.getMustacheKeysForTreeNode(encodedTemplate);
        }
        return Collections.emptyList();
    }
}

