/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.text.model;

import de.larmic.butterfaces.component.html.text.HtmlTreeBox;
import de.larmic.butterfaces.component.renderkit.html_basic.text.model.TreeBoxModelType;
import de.larmic.butterfaces.model.tree.DefaultNodeImpl;
import de.larmic.butterfaces.model.tree.Node;
import java.util.ArrayList;
import java.util.List;

public class TreeBoxModelWrapper {
    private final List<Node> nodes = new ArrayList<Node>();
    private final TreeBoxModelType treeBoxModelType;

    public TreeBoxModelWrapper(HtmlTreeBox treeBox) {
        Object treeBoxValues = treeBox.getValues();
        if (treeBoxValues instanceof Node) {
            this.nodes.add((Node)treeBoxValues);
            this.treeBoxModelType = TreeBoxModelType.NODES;
        } else {
            this.treeBoxModelType = treeBoxValues instanceof Iterable ? this.handleIterableValues((Iterable)treeBoxValues) : TreeBoxModelType.UNKNOWN;
        }
    }

    private TreeBoxModelType handleIterableValues(Iterable treeBoxValues) {
        boolean foundNode = false;
        boolean foundObject = false;
        if (!treeBoxValues.iterator().hasNext()) {
            return TreeBoxModelType.UNKNOWN;
        }
        for (Object value : treeBoxValues) {
            if (value instanceof Node) {
                this.nodes.add((Node)value);
                foundNode = true;
                continue;
            }
            if (value instanceof String) {
                this.nodes.add(new DefaultNodeImpl<String>((String)value, (String)value));
                foundObject = true;
                continue;
            }
            this.nodes.add(new DefaultNodeImpl(null, value));
            foundObject = true;
        }
        return foundObject ? TreeBoxModelType.OBJECTS : (foundNode ? TreeBoxModelType.NODES : TreeBoxModelType.UNKNOWN);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public TreeBoxModelType getTreeBoxModelType() {
        return this.treeBoxModelType;
    }
}

