/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.text;

import de.larmic.butterfaces.component.html.text.HtmlTreeBox;
import de.larmic.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.model.CachedNodesInitializer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.model.TreeBoxModelType;
import de.larmic.butterfaces.component.renderkit.html_basic.text.model.TreeBoxModelWrapper;
import de.larmic.butterfaces.component.renderkit.html_basic.text.part.TrivialComponentsEntriesNodePartRenderer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.util.TrivialComponentsUtil;
import de.larmic.butterfaces.context.StringHtmlEncoder;
import de.larmic.butterfaces.model.tree.EnumTreeBoxWrapper;
import de.larmic.butterfaces.model.tree.Node;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.TreeBoxRenderer")
public class TreeBoxRenderer
extends AbstractHtmlTagRenderer<HtmlTreeBox> {
    public static final String DEFAULT_SINGLE_LINE_OF_TEXT_TEMPLATE = "<div class=\"tr-template-single-line\">  <div class=\"content-wrapper tr-editor-area\">     <div>{{butterObjectToString}}</div>   </div></div>";

    @Override
    protected boolean encodeReadonly() {
        return false;
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component, "butter-component-treebox");
    }

    @Override
    protected void appendEncodeBegin(HtmlTreeBox treeBox, ResponseWriter writer) throws IOException {
        String clientIdSeparator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()));
        String treeBoxReadableId = treeBox.getClientId().replace(clientIdSeparator, "_");
        writer.writeAttribute("data-tree-box-id", (Object)treeBoxReadableId, null);
    }

    @Override
    protected void encodeEnd(HtmlTreeBox treeBox, ResponseWriter writer) throws IOException {
        if (!treeBox.isReadonly() || treeBox.getValue() != null) {
            TreeBoxModelWrapper treeBoxModelWrapper = new TreeBoxModelWrapper(treeBox);
            List<Node> nodes = treeBoxModelWrapper.getNodes();
            TreeBoxModelType treeBoxModelType = treeBoxModelWrapper.getTreeBoxModelType();
            List<String> mustacheKeys = TrivialComponentsUtil.createMustacheKeys(FacesContext.getCurrentInstance(), (UIComponentBase)treeBox);
            String clientIdSeparator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()));
            Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(nodes);
            writer.startElement("script", (UIComponent)treeBox);
            writer.writeText((Object)"jQuery(function () {\n", null);
            String treeBoxReadableId = treeBox.getClientId().replace(clientIdSeparator, "_");
            writer.writeText((Object)("var entries_" + treeBoxReadableId + " = " + new TrivialComponentsEntriesNodePartRenderer().renderEntriesAsJSON(nodes, TrivialComponentsUtil.replaceDotInMustacheKeys(mustacheKeys), nodesMap) + ";\n"), null);
            String jQueryBySelector = RenderUtils.createJQueryBySelector(treeBox.getClientId(), "input");
            String pluginCall = TrivialComponentsUtil.replaceDotInMustacheKeys(mustacheKeys, this.createJQueryPluginCallTrivial(treeBox, treeBoxModelType, mustacheKeys, nodesMap));
            writer.writeText((Object)("ButterFaces.TreeBox.removeTrivialTreeDropDown('" + treeBoxReadableId + "');\n"), null);
            writer.writeText((Object)("var trivialTree" + treeBoxReadableId + " = " + jQueryBySelector + pluginCall + "\n"), null);
            writer.writeText((Object)("$(trivialTree" + treeBoxReadableId + ".getDropDown()).attr('data-tree-box-id', '" + treeBoxReadableId + "')"), null);
            writer.writeText((Object)"});", null);
            writer.endElement("script");
        }
    }

    @Override
    protected void encodeInnerEnd(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlTreeBox treeBox = (HtmlTreeBox)component;
        if (treeBox.isReadonly()) {
            if (treeBox.getValue() == null) {
                new ReadonlyPartRenderer().renderReadonly(treeBox, writer);
            } else {
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)"butter-component-value", null);
                super.encodeSuperEnd(FacesContext.getCurrentInstance(), component);
                writer.endElement("div");
            }
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null || "".equals(submittedValue)) {
            return null;
        }
        String newValue = (String)submittedValue;
        HtmlTreeBox treeBox = (HtmlTreeBox)component;
        TreeBoxModelWrapper treeBoxModelWrapper = new TreeBoxModelWrapper(treeBox);
        TreeBoxModelType treeBoxModelType = treeBoxModelWrapper.getTreeBoxModelType();
        List<Node> nodes = treeBoxModelWrapper.getNodes();
        Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(nodes);
        Integer selectedIndex = Integer.valueOf(newValue);
        Node node = nodesMap.get(selectedIndex);
        return treeBoxModelType == TreeBoxModelType.OBJECTS && node != null ? (node.getData() instanceof EnumTreeBoxWrapper ? ((EnumTreeBoxWrapper)node.getData()).getEnumValue() : node.getData()) : node;
    }

    private String createJQueryPluginCallTrivial(HtmlTreeBox treeBox, TreeBoxModelType treeBoxModelType, List<String> mustacheKeys, Map<Integer, Node> nodesMap) throws IOException {
        StringBuilder jQueryPluginCall = new StringBuilder();
        FacesContext context = FacesContext.getCurrentInstance();
        Integer selectedEntryId = this.findValueInCachedNodes(treeBox.getValue(), treeBoxModelType, nodesMap);
        Node selectedNode = selectedEntryId != null ? nodesMap.get(selectedEntryId) : null;
        String editable = TrivialComponentsEntriesNodePartRenderer.getEditingMode(treeBox);
        WebXmlParameters webXmlParameters = new WebXmlParameters(context.getExternalContext());
        String noMatchingText = StringUtils.getNotNullValue(treeBox.getNoEntriesText(), webXmlParameters.getNoEntriesText());
        String spinnerText = StringUtils.getNotNullValue(treeBox.getSpinnerText(), webXmlParameters.getSpinnerText());
        if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            jQueryPluginCall.append("TrivialComboBox({");
        } else {
            jQueryPluginCall.append("TrivialTreeComboBox({");
        }
        jQueryPluginCall.append("\n    allowFreeText: false,");
        if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            jQueryPluginCall.append("\n    valueProperty: 'id',");
        }
        if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            jQueryPluginCall.append("\n    inputTextProperty: '" + StringUtils.getNotNullValue(treeBox.getInputTextProperty(), "butterObjectToString") + "',");
        } else {
            jQueryPluginCall.append("\n    inputTextProperty: '" + StringUtils.getNotNullValue(treeBox.getInputTextProperty(), "title") + "',");
        }
        if (treeBox.getFacet("emptyEntryTemplate") != null) {
            jQueryPluginCall.append("\n    emptyEntryTemplate: '" + StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, treeBox.getFacet("emptyEntryTemplate")) + "',");
        } else if (StringUtils.isNotEmpty(treeBox.getPlaceholder())) {
            jQueryPluginCall.append("\n    emptyEntryTemplate: '<div class=\"defaultEmptyEntry\">" + treeBox.getPlaceholder() + "</div>',");
        }
        jQueryPluginCall.append("\n    editingMode: '" + editable + "',");
        jQueryPluginCall.append("\n    showClearButton: ").append(this.evaluateShowClearButtonValue(treeBox, webXmlParameters)).append(",");
        if (selectedEntryId != null && selectedNode != null) {
            jQueryPluginCall.append("\n    selectedEntry: " + new TrivialComponentsEntriesNodePartRenderer().renderNode(mustacheKeys, nodesMap, selectedEntryId, selectedNode) + ",");
        }
        if (treeBox.getFacet("selectedEntryTemplate") != null) {
            jQueryPluginCall.append("\n    selectedEntryTemplate: '" + StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, treeBox.getFacet("selectedEntryTemplate")) + "',");
        }
        if (treeBox.getFacet("template") != null) {
            String encodedTemplate = StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, treeBox.getFacet("template"));
            if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
                jQueryPluginCall.append("\n    template: '" + encodedTemplate + "',");
            } else {
                jQueryPluginCall.append("\n    templates: ['" + encodedTemplate + "'],");
            }
        } else if (treeBoxModelType == TreeBoxModelType.NODES) {
            jQueryPluginCall.append("\n    templates: ['<div class=\"tr-template-icon-2-lines tr-tree-entry filterable-item {{styleClass}}\">  <div class=\"img-wrapper {{imageClass}}\" style=\"{{imageStyle}}\"></div>  <div class=\"content-wrapper tr-editor-area\">     <div class=\"main-line\">{{title}}</div>     <div class=\"additional-info\">{{description}}</div>  </div></div>'],");
        } else if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            jQueryPluginCall.append("\n    template: '<div class=\"tr-template-single-line\">  <div class=\"content-wrapper tr-editor-area\">     <div>{{butterObjectToString}}</div>   </div></div>',");
        }
        jQueryPluginCall.append("\n    spinnerTemplate: '<div class=\"tr-default-spinner\"><div class=\"spinner\"></div><div>" + spinnerText + "</div></div>',");
        jQueryPluginCall.append("\n    noEntriesTemplate: '<div class=\"tr-default-no-data-display\"><div>" + noMatchingText + "</div></div>',");
        jQueryPluginCall.append("\n    entries: entries_" + treeBox.getClientId().replace(":", "_"));
        jQueryPluginCall.append("});");
        return jQueryPluginCall.toString();
    }

    boolean evaluateShowClearButtonValue(HtmlTreeBox treeBox, WebXmlParameters webXmlParameters) {
        boolean showClearButtonConf = treeBox.getShowClearButton() == null ? webXmlParameters.isShowTreeBoxClearButton() : treeBox.getShowClearButton().booleanValue();
        return showClearButtonConf;
    }

    private Integer findValueInCachedNodes(Object treeBoxValue, TreeBoxModelType treeBoxModelType, Map<Integer, Node> nodesMap) {
        block3: {
            block2: {
                if (treeBoxModelType != TreeBoxModelType.OBJECTS || treeBoxValue == null) break block2;
                for (Integer index : nodesMap.keySet()) {
                    Node node = nodesMap.get(index);
                    if (node.getData() == null || !node.getData().equals(treeBoxValue)) continue;
                    return index;
                }
                break block3;
            }
            if (treeBoxValue == null) break block3;
            for (Integer index : nodesMap.keySet()) {
                Node node = nodesMap.get(index);
                if (!node.equals(treeBoxValue)) continue;
                return index;
            }
        }
        return null;
    }
}

