/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.text;

import de.larmic.butterfaces.component.html.text.HtmlTags;
import de.larmic.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.model.CachedNodesInitializer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.part.TrivialComponentsEntriesNodePartRenderer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.util.FreeTextSeparators;
import de.larmic.butterfaces.component.renderkit.html_basic.text.util.TrivialComponentsUtil;
import de.larmic.butterfaces.model.tree.DefaultNodeImpl;
import de.larmic.butterfaces.model.tree.Node;
import de.larmic.butterfaces.util.StringJoiner;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.TagsRenderer")
public class TagsRenderer
extends AbstractHtmlTagRenderer<HtmlTags> {
    @Override
    protected boolean encodeReadonly() {
        return false;
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component, "butter-component-tags");
    }

    @Override
    protected void encodeInnerEnd(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlTags htmlTags = (HtmlTags)component;
        if (htmlTags.isReadonly()) {
            if (htmlTags.getValue() == null || StringUtils.isEmpty((String)htmlTags.getValue())) {
                new ReadonlyPartRenderer().renderReadonly(htmlTags, writer);
            } else {
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)"butter-component-value", null);
                super.encodeSuperEnd(FacesContext.getCurrentInstance(), component);
                writer.endElement("div");
            }
        }
    }

    @Override
    protected void encodeEnd(HtmlTags htmlTags, ResponseWriter writer) throws IOException {
        writer.startElement("script", (UIComponent)htmlTags);
        String clientIdSeparator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()));
        String treeBoxReadableId = htmlTags.getClientId().replace(clientIdSeparator, "_");
        List<Node> entries = this.createEntries(htmlTags.getEntries());
        writer.writeText((Object)"jQuery(function () {\n", null);
        if (!entries.isEmpty()) {
            List<String> mustacheKeys = TrivialComponentsUtil.createMustacheKeys(FacesContext.getCurrentInstance(), (UIComponentBase)htmlTags);
            Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(entries);
            writer.writeText((Object)("var entries_" + treeBoxReadableId + " = " + new TrivialComponentsEntriesNodePartRenderer().renderEntriesAsJSON(entries, TrivialComponentsUtil.replaceDotInMustacheKeys(mustacheKeys), nodesMap) + ";\n"), null);
        }
        String jQueryBySelector = RenderUtils.createJQueryBySelector(htmlTags.getClientId(), ".butter-input-component");
        String pluginCall = this.createJQueryPluginCallTrivial(htmlTags, entries.isEmpty() ? null : "entries_" + treeBoxReadableId);
        writer.writeText((Object)("var trivialTags" + treeBoxReadableId + " = " + jQueryBySelector + pluginCall + "\n"), null);
        writer.writeText((Object)(RenderUtils.createJQueryBySelector(htmlTags.getClientId(), null) + "_butterTagsInit(); \n"), null);
        writer.writeText((Object)"});", null);
        writer.endElement("script");
    }

    private String createJQueryPluginCallTrivial(HtmlTags tags, String entriesVar) throws IOException {
        String selectedEntries;
        StringBuilder jQueryPluginCall = new StringBuilder();
        String editable = TrivialComponentsEntriesNodePartRenderer.getEditingMode(tags);
        jQueryPluginCall.append("TrivialTagBox({");
        jQueryPluginCall.append("\n    autoComplete: " + tags.isAutoComplete() + ",");
        jQueryPluginCall.append("\n    allowFreeText: true,");
        jQueryPluginCall.append("\n    showTrigger: false,");
        jQueryPluginCall.append("\n    distinct: " + tags.isDistinct() + ",");
        jQueryPluginCall.append("\n    editingMode: '" + editable + "',");
        jQueryPluginCall.append("\n    matchingOptions: { \n            \"matchingMode\": \"contains\",\n            \"ignoreCase\": true\n        },");
        if (tags.getMaxTags() != null) {
            jQueryPluginCall.append("\n    maxSelectedEntries: " + tags.getMaxTags() + ",");
        }
        if (StringUtils.isNotEmpty(selectedEntries = this.getSelectedEntries(tags))) {
            jQueryPluginCall.append("\n    selectedEntries: [" + selectedEntries + "],");
        }
        if (StringUtils.isNotEmpty(entriesVar)) {
            jQueryPluginCall.append("\n    valueProperty: 'id',");
            jQueryPluginCall.append("\n    entries: " + entriesVar + ",");
            jQueryPluginCall.append("\n    template: '<div class=\"tr-template-single-line\">  <div class=\"content-wrapper tr-editor-area\">     <div>{{butterObjectToString}}</div>   </div></div>',");
            jQueryPluginCall.append("\n    inputTextProperty: 'butterObjectToString',");
        } else {
            jQueryPluginCall.append("\n    valueProperty: 'displayValue',");
            jQueryPluginCall.append("\n    template: TrivialComponents.singleLineTemplate,");
        }
        jQueryPluginCall.append("\n    freeTextSeparators: " + this.createFreeTextSeparators(tags) + ",");
        jQueryPluginCall.append("\n    valueSeparator: [',']");
        jQueryPluginCall.append("});");
        return jQueryPluginCall.toString();
    }

    private List<Node> createEntries(List<Object> objects) {
        ArrayList<Node> entries = new ArrayList<Node>();
        if (objects != null) {
            for (Object object : objects) {
                entries.add(new DefaultNodeImpl<Object>(null, object));
            }
        }
        return entries;
    }

    private String createFreeTextSeparators(HtmlTags tags) {
        return "[" + StringUtils.joinWithCommaSeparator(FreeTextSeparators.getFreeTextSeparators(tags), true) + "]";
    }

    private String getSelectedEntries(HtmlTags tags) {
        String componentValue = this.getSubmittedValueOrValue(tags);
        if (StringUtils.isNotEmpty(componentValue)) {
            List<String> freeTextSeparators = FreeTextSeparators.getFreeTextSeparators(tags);
            String valueSplitter = StringJoiner.on("|").join(freeTextSeparators).toString();
            Iterator<String> iterator = new ArrayList<String>(Arrays.asList(componentValue.split(valueSplitter))).iterator();
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (!StringUtils.isNotEmpty(next)) continue;
                sb.append("{displayValue:'" + this.escapeDisplayValue(next) + "'}");
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    private String escapeDisplayValue(String value) {
        return value.replaceAll("'", "\\\\'");
    }

    private String getSubmittedValueOrValue(HtmlTags tags) {
        if (tags.getSubmittedValue() != null) {
            return tags.getSubmittedValue().toString();
        }
        if (tags.getValue() != null) {
            return tags.getValue().toString();
        }
        return null;
    }
}

