/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.text;

import de.larmic.butterfaces.component.html.text.HtmlCalendar;
import de.larmic.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.CalendarRenderer")
public class CalendarRenderer
extends AbstractHtmlTagRenderer<HtmlCalendar> {
    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlCalendar calendar = (HtmlCalendar)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!calendar.isReadonly()) {
            super.encodeSuperEnd(context, component);
            if (calendar.isPickDate() || calendar.isPickTime()) {
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)"input-group-addon cursor-pointer", null);
                writer.startElement("span", component);
                if (!calendar.isPickDate()) {
                    writer.writeAttribute("class", (Object)"glyphicon glyphicon-time", null);
                } else {
                    writer.writeAttribute("class", (Object)"glyphicon glyphicon-calendar", null);
                }
                writer.endElement("span");
                writer.endElement("span");
            }
        }
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd((UIComponent)calendar, writer);
        this.renderTooltipIfNecessary(context, (UIComponent)calendar);
        if (!calendar.isReadonly() && (calendar.isPickDate() || calendar.isPickTime())) {
            writer.startElement("script", (UIComponent)calendar);
            writer.writeText((Object)RenderUtils.createJQueryPluginCall(component.getClientId(), ".input-group", this.createJQueryPluginCall(calendar)), null);
            writer.writeText((Object)RenderUtils.createJQueryPluginCall(component.getClientId(), ".input-group", this.createJQueryPluginCallback(calendar)), null);
            writer.endElement("script");
        }
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    private String createJQueryPluginCall(HtmlCalendar calendar) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        String calendarDate = StringUtils.getNotNullValue(calendar.getGlyphiconDate(), "glyphicon glyphicon-calendar");
        String calendarTime = StringUtils.getNotNullValue(calendar.getGlyphiconTime(), "glyphicon glyphicon-time");
        String calendarUp = StringUtils.getNotNullValue(calendar.getGlyphiconUp(), "glyphicon glyphicon-chevron-up");
        String calendarDown = StringUtils.getNotNullValue(calendar.getGlyphiconDown(), "glyphicon glyphicon-chevron-down");
        jQueryPluginCall.append("datetimepicker({");
        if (StringUtils.isNotEmpty(calendar.getFormat())) {
            jQueryPluginCall.append("format: \"").append(calendar.getFormat()).append("\",");
        } else if (calendar.isPickDate() && !calendar.isPickTime()) {
            jQueryPluginCall.append("format: \"L\",");
        } else if (!calendar.isPickDate() && calendar.isPickTime()) {
            jQueryPluginCall.append("format: \"LT\",");
        }
        if (StringUtils.isNotEmpty(calendar.getLanguage())) {
            jQueryPluginCall.append("locale: \"" + calendar.getLanguage() + "\",");
        }
        jQueryPluginCall.append("sideBySide: " + calendar.isSideBySide() + ",");
        jQueryPluginCall.append("icons: {");
        jQueryPluginCall.append("time: '" + calendarTime + "',");
        jQueryPluginCall.append("date: '" + calendarDate + "',");
        jQueryPluginCall.append("up: '" + calendarUp + "',");
        jQueryPluginCall.append("down: '" + calendarDown + "'");
        jQueryPluginCall.append("}");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }

    private String createJQueryPluginCallback(HtmlCalendar calendar) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("on(\"dp.change\", function (e) {");
        jQueryPluginCall.append(RenderUtils.createJQueryBySelector(calendar.getClientId(), ".butter-input-component") + "trigger('change');");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }
}

