/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.table;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.behavior.JsfAjaxRequest;
import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.table.cache.TableColumnCache;
import de.larmic.butterfaces.event.TableSingleSelectionListener;
import de.larmic.butterfaces.model.table.SortType;
import de.larmic.butterfaces.resolver.ClientBehaviorResolver;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import de.larmic.butterfaces.util.StringJoiner;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.TableRenderer.new")
public class TableRenderer
extends HtmlBasicRenderer {
    private boolean hasColumnWidthSet;
    private int rowIndex;
    private boolean foundSelectedRow;
    private WebXmlParameters webXmlParameters;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlTable table = (HtmlTable)component;
        TableColumnCache tableColumnCache = table.getTableColumnCache(context);
        this.hasColumnWidthSet = this.hasColumnWidthSet(tableColumnCache.getCachedColumns());
        this.rowIndex = 0;
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        this.foundSelectedRow = false;
        table.setRowIndex(-1);
        ResponseWriter writer = context.getResponseWriter();
        this.renderTableStart(context, table, writer);
        this.renderHeader(context, table, writer);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlTable table = (HtmlTable)component;
        ResponseWriter writer = context.getResponseWriter();
        int rows = table.getRows();
        int processed = 0;
        int rowIndex = table.getFirst() - 1;
        writer.startElement("tbody", component);
        while (rows <= 0 || ++processed <= rows) {
            table.setRowIndex(++rowIndex);
            if (!table.isRowAvailable()) break;
            this.renderRowStart(table, writer);
            this.renderRow(context, table, writer);
            this.renderRowEnd(writer);
        }
        writer.endElement("tbody");
        table.setRowIndex(-1);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ((HtmlTable)component).clearMetaInfo(context, component);
        ((UIData)component).setRowIndex(-1);
        this.renderTableEnd(context.getResponseWriter());
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void renderHeader(FacesContext context, HtmlTable table, ResponseWriter writer) throws IOException {
        int columnNumber;
        TableColumnCache tableColumnCache = table.getTableColumnCache(context);
        if (this.hasColumnWidthSet) {
            writer.startElement("colgroup", (UIComponent)table);
            columnNumber = 0;
            for (HtmlColumn column : tableColumnCache.getCachedColumns()) {
                writer.startElement("col", (UIComponent)table);
                writer.writeAttribute("class", (Object)"butter-table-colgroup", null);
                writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
                StringBuilder style = new StringBuilder();
                if (StringUtils.isNotEmpty(column.getColWidth())) {
                    style.append("width: ");
                    style.append(column.getColWidth());
                }
                if (table.isHideColumn(column)) {
                    if (style.length() > 0) {
                        style.append("; ");
                    }
                    style.append("display: none");
                }
                if (style.length() > 0) {
                    writer.writeAttribute("style", (Object)style.toString(), null);
                }
                writer.endElement("col");
                ++columnNumber;
            }
            writer.endElement("colgroup");
        }
        writer.startElement("thead", (UIComponent)table);
        writer.startElement("tr", (UIComponent)table);
        columnNumber = 0;
        for (HtmlColumn column : tableColumnCache.getCachedColumns()) {
            column.setWebXmlParameters(this.webXmlParameters);
            column.setColumnNumberUsedByTable(columnNumber);
            column.encodeBegin(context);
            column.encodeEnd(context);
            ++columnNumber;
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    private void renderTableStart(FacesContext context, HtmlTable table, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)table.getClientId(context), "id");
        writer.writeAttribute("class", (Object)StringJoiner.on(' ').join("butter-table").join(StringUtils.getNullSafeValue(table.getStyleClass())).toString(), null);
        if (StringUtils.isNotEmpty(table.getStyle())) {
            writer.writeAttribute("style", (Object)table.getStyle(), null);
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("class", (Object)"table-responsive", "styleClass");
        writer.startElement("table", (UIComponent)table);
        StringBuilder tableStyleClass = new StringBuilder("table table-hover");
        if (this.hasColumnWidthSet) {
            tableStyleClass.append(" table-fixed");
        }
        if (table.isTableCondensed()) {
            tableStyleClass.append(" table-condensed");
        }
        if (table.isTableBordered()) {
            tableStyleClass.append(" table-bordered");
        }
        if (table.isTableStriped()) {
            tableStyleClass.append(" table-striped");
        }
        writer.writeAttribute("class", (Object)tableStyleClass.toString(), "styleClass");
        writer.writeText((Object)"\n", (UIComponent)table, null);
    }

    private void renderTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderRowStart(HtmlTable table, ResponseWriter writer) throws IOException {
        String rowClass;
        String clientId = table.getClientId();
        String baseClientId = clientId.substring(0, clientId.length() - (this.rowIndex + "").length() - 1);
        writer.startElement("tr", (UIComponent)table);
        writer.writeAttribute("rowIndex", (Object)this.rowIndex, null);
        String string = rowClass = StringUtils.isNotEmpty(table.getRowClass()) ? "butter-table-row " + table.getRowClass() : "butter-table-row";
        if (!this.foundSelectedRow && this.isRowSelected(table, this.rowIndex)) {
            writer.writeAttribute("class", (Object)(rowClass + " butter-table-row-selected"), null);
            this.foundSelectedRow = true;
        } else {
            writer.writeAttribute("class", (Object)rowClass, null);
        }
        AjaxBehavior clickAjaxBehavior = ClientBehaviorResolver.resolveActiveAjaxBehavior((UIComponentBase)table, "click");
        if (clickAjaxBehavior != null && table.getSingleSelectionListener() != null) {
            JsfAjaxRequest ajaxRequest = new JsfAjaxRequest(baseClientId, true).setEvent("click_" + this.rowIndex).setRender((UIComponentBase)table, "click").setBehaviorEvent("click_" + this.rowIndex);
            String jQueryPluginCall = RenderUtils.createJQueryPluginCall(table.getClientId(), "selectTableRow({rowIndex:'" + this.rowIndex + "'})");
            writer.writeAttribute("onclick", (Object)(ajaxRequest.toString() + ";" + jQueryPluginCall.replaceFirst(clientId, baseClientId)), null);
        }
        writer.writeText((Object)"\n", (UIComponent)table, null);
        ++this.rowIndex;
    }

    private void renderRowEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    private void renderRow(FacesContext context, HtmlTable table, ResponseWriter writer) throws IOException {
        TableColumnCache info = table.getTableColumnCache(context);
        int columnNumber = 0;
        for (HtmlColumn column : info.getCachedColumns()) {
            if (table.isHideColumn(column)) continue;
            boolean isRowHeader = false;
            Object rowHeaderValue = column.getAttributes().get("rowHeader");
            if (null != rowHeaderValue) {
                isRowHeader = Boolean.valueOf(rowHeaderValue.toString());
            }
            if (isRowHeader) {
                writer.startElement("th", (UIComponent)column);
                writer.writeAttribute("scope", (Object)"row", null);
            } else {
                writer.startElement("td", (UIComponent)column);
                StringBuilder sb = new StringBuilder("butter-component-table-column");
                if (StringUtils.isNotEmpty(column.getStyleClass())) {
                    sb.append(" ").append(column.getStyleClass());
                }
                writer.writeAttribute("class", (Object)sb.toString(), null);
                writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
                if (table.isHideColumn(column)) {
                    writer.writeAttribute("style", (Object)"display:none", null);
                } else if (StringUtils.isNotEmpty(column.getStyle())) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
            }
            Iterator<UIComponent> gkids = this.getChildren((UIComponent)column);
            while (gkids.hasNext()) {
                this.encodeRecursive(context, gkids.next());
            }
            if (isRowHeader) {
                writer.endElement("th");
            } else {
                writer.endElement("td");
            }
            ++columnNumber;
        }
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        HtmlTable table = (HtmlTable)component;
        Map behaviors = table.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Object untypedTableValue = table.getValue();
        if (!(untypedTableValue instanceof Iterable)) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && behaviorEvent.contains("_")) {
            String[] split = behaviorEvent.split("_");
            String event = split[0];
            try {
                int eventNumber = Integer.valueOf(split[1]);
                if ("click".equals(event)) {
                    TableSingleSelectionListener listener;
                    Object rowObject = this.findRowObject(table, eventNumber);
                    if (rowObject != null && (listener = table.getSingleSelectionListener()) != null) {
                        listener.processTableSelection(rowObject);
                    }
                } else if ("sort".equals(event) && table.getModel() != null) {
                    TableColumnCache tableColumnCache = table.getTableColumnCache(context);
                    HtmlColumn sortedColumn = tableColumnCache.getCachedColumns().get(eventNumber);
                    String tableUniqueIdentifier = table.getModelUniqueIdentifier();
                    String columnUniqueIdentifier = sortedColumn.getModelUniqueIdentifier();
                    if (table.getTableSortModel().getSortType(tableUniqueIdentifier, columnUniqueIdentifier) == SortType.ASCENDING) {
                        table.getTableSortModel().sortColumn(tableUniqueIdentifier, columnUniqueIdentifier, sortedColumn.getSortBy(), SortType.DESCENDING);
                    } else {
                        table.getTableSortModel().sortColumn(tableUniqueIdentifier, columnUniqueIdentifier, sortedColumn.getSortBy(), SortType.ASCENDING);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean isRowSelected(HtmlTable table, int rowIndex) {
        if (table.getSingleSelectionListener() != null) {
            Object rowObject = this.findRowObject(table, rowIndex);
            return table.getSingleSelectionListener().isValueSelected(rowObject);
        }
        return false;
    }

    private Object findRowObject(HtmlTable table, int row) {
        Object value = table.getValue();
        if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            int actualRow = 0;
            while (iterator.hasNext()) {
                Object value1 = iterator.next();
                if (actualRow == row) {
                    return value1;
                }
                ++actualRow;
            }
            return null;
        }
        return null;
    }

    private boolean hasColumnWidthSet(List<HtmlColumn> columns) {
        for (HtmlColumn column : columns) {
            if (!StringUtils.isNotEmpty(column.getColWidth())) continue;
            return true;
        }
        return false;
    }
}

