/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.table;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.behavior.JsfAjaxRequest;
import de.larmic.butterfaces.component.html.HtmlTooltip;
import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.renderkit.html_basic.table.TableToolbarRenderer;
import de.larmic.butterfaces.model.table.SortType;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.ColumnRenderer.new")
public class ColumnRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        HtmlColumn column = (HtmlColumn)component;
        HtmlTable table = this.findParentTable(component);
        int columnNumber = column.getColumnNumberUsedByTable();
        WebXmlParameters webXmlParameters = column.getWebXmlParameters();
        HtmlTooltip tooltip = this.findTooltip(component);
        if (tooltip != null) {
            tooltip.setFor("[data-tooltip-identifier=\"" + this.createTooltipIdentifier(column) + "\"]");
        }
        writer.startElement("th", component);
        writer.writeAttribute("id", (Object)column.getClientId(), null);
        if (column.isSortColumnEnabled() && table.getTableSortModel() != null) {
            writer.writeAttribute("class", (Object)"butter-component-table-column-header butter-component-table-column-sort", null);
        } else {
            writer.writeAttribute("class", (Object)"butter-component-table-column-header", null);
        }
        writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
        if (table.isHideColumn(column)) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        List<String> renderIds = JsfAjaxRequest.createRerenderIds((UIComponentBase)table, "click");
        if (column.isSortColumnEnabled() && table.getModel() != null && !renderIds.isEmpty()) {
            renderIds.add(table.getClientId());
            String ajax = TableToolbarRenderer.createModelJavaScriptCall(table.getClientId(), renderIds, "sortTableRow", table.isAjaxDisableRenderRegionsOnRequest(), columnNumber + "");
            writer.writeAttribute("onclick", (Object)ajax, null);
        }
        writer.startElement("div", component);
        writer.writeAttribute("data-tooltip-identifier", (Object)this.createTooltipIdentifier(column), null);
        writer.writeAttribute("class", (Object)column.getHeaderStyleClass(), null);
        writer.writeAttribute("style", (Object)column.getHeaderStyle(), null);
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)"butter-component-table-column-label", null);
        writer.writeText((Object)column.getLabel(), null);
        writer.endElement("span");
        if (column.isSortColumnEnabled() && table.getTableSortModel() != null && !renderIds.isEmpty()) {
            writer.startElement("span", component);
            String tableUniqueIdentifier = table.getModelUniqueIdentifier();
            String columnUniqueIdentifier = column.getModelUniqueIdentifier();
            SortType sortType = table.getModel().getTableRowSortingModel().getSortType(tableUniqueIdentifier, columnUniqueIdentifier);
            StringBuilder sortSpanStyleClass = new StringBuilder("butter-component-table-column-sort-spinner ");
            if (sortType == SortType.ASCENDING) {
                sortSpanStyleClass.append(" " + webXmlParameters.getSortAscGlyphicon());
            } else if (sortType == SortType.DESCENDING) {
                sortSpanStyleClass.append(" " + webXmlParameters.getSortDescGlyphicon());
            } else {
                sortSpanStyleClass.append(" " + webXmlParameters.getSortUnknownGlyphicon());
            }
            writer.writeAttribute("class", (Object)sortSpanStyleClass.toString(), null);
            writer.endElement("span");
        }
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.endElement("th");
    }

    private String createTooltipIdentifier(HtmlColumn column) {
        return column.getClientId() + "_div";
    }

    private HtmlTooltip findTooltip(UIComponent component) {
        for (UIComponent uiComponent : component.getChildren()) {
            if (!(uiComponent instanceof HtmlTooltip)) continue;
            return (HtmlTooltip)uiComponent;
        }
        return null;
    }

    private HtmlTable findParentTable(UIComponent component) {
        return component instanceof HtmlTable || component == null ? (HtmlTable)component : this.findParentTable(component.getParent());
    }
}

