/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.html.HtmlTooltip;
import de.larmic.butterfaces.component.html.feature.Readonly;
import de.larmic.butterfaces.component.html.feature.Tooltip;
import de.larmic.butterfaces.component.html.text.HtmlTags;
import de.larmic.butterfaces.component.html.text.HtmlTreeBox;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.TooltipRenderer")
public class TooltipRenderer
extends HtmlBasicRenderer {
    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlTooltip tooltip = (HtmlTooltip)component;
        ResponseWriter writer = context.getResponseWriter();
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        String contentId = component.getClientId().replace(separatorChar + "", "_");
        String forSelector = this.getForElement(tooltip);
        if (StringUtils.isNotEmpty(forSelector)) {
            writer.startElement("span", (UIComponent)tooltip);
            writer.writeAttribute("name", (Object)contentId, null);
            writer.writeAttribute("class", (Object)"butter-component-tooltip-temp-content", null);
            if (StringUtils.isEmpty(tooltip.getFor()) && tooltip.getParent() instanceof Tooltip) {
                this.renderValidationErrors(context, writer, tooltip.getParent());
            }
            for (UIComponent child : tooltip.getChildren()) {
                child.encodeAll(context);
            }
            writer.endElement("span");
            writer.startElement("script", (UIComponent)tooltip);
            writer.writeText((Object)"jQuery(document).ready(function() {\n", null);
            writer.writeText((Object)"   jQuery(", null);
            writer.writeText((Object)forSelector, null);
            writer.writeText((Object)")._butterTooltip({\n", null);
            writer.writeText((Object)"      trigger: ", null);
            writer.writeText((Object)this.getNullSafeStringParameter(tooltip.getTrigger()), null);
            writer.writeText((Object)",\n      title: ", null);
            writer.writeText((Object)this.getNullSafeStringParameter(tooltip.getTitle()), null);
            writer.writeText((Object)",\n      placement: ", null);
            writer.writeText((Object)this.getNullSafeStringParameter(tooltip.getPlacement()), null);
            writer.writeText((Object)",\n      placementFunction: ", null);
            writer.writeText((Object)this.getNullSafeFunctionParameter(tooltip.getPlacementFunction()), null);
            writer.writeText((Object)",\n      contentByName: '", null);
            writer.writeText((Object)contentId, null);
            writer.writeText((Object)"',\n      minVerticalOffset: ", null);
            writer.writeText((Object)this.getNullSafeIntegerParameter(tooltip.getMinVerticalOffset()), null);
            writer.writeText((Object)",\n      minHorizontalOffset: ", null);
            writer.writeText((Object)this.getNullSafeIntegerParameter(tooltip.getMinHorizontalOffset()), null);
            writer.writeText((Object)",\n      viewport: ", null);
            writer.writeText((Object)("'" + StringUtils.getNotNullValue(tooltip.getViewport(), "body") + "'"), null);
            writer.writeText((Object)"\n   })\n});", null);
            if (StringUtils.isNotEmpty(tooltip.getOnShow()) || StringUtils.isNotEmpty(tooltip.getOnShown()) || StringUtils.isNotEmpty(tooltip.getOnHide()) || StringUtils.isNotEmpty(tooltip.getOnHidden())) {
                this.encodePopoverEvent(forSelector, tooltip.getOnShow(), "show.bs.popover", component, writer);
                this.encodePopoverEvent(forSelector, tooltip.getOnShown(), "shown.bs.popover", component, writer);
                this.encodePopoverEvent(forSelector, tooltip.getOnHide(), "hide.bs.popover", component, writer);
                this.encodePopoverEvent(forSelector, tooltip.getOnHidden(), "hidden.bs.popover", component, writer);
            }
            if (StringUtils.isEmpty(tooltip.getFor()) && this.isTooltipParentReadonly(tooltip)) {
                writer.writeText((Object)"jQuery(document).ready(function() {", null);
                writer.writeText((Object)("\n    jQuery(" + this.createParentForElement(tooltip) + ").find('.butter-component-label').on('" + this.convertTooltipTriggerToJavaScriptEvent(tooltip.getTrigger()) + "', function(e) {"), component, null);
                writer.writeText((Object)("\n        jQuery(" + this.createParentReadonlyForElement(tooltip) + ").trigger(e.type);"), component, null);
                writer.writeText((Object)"\n    });", component, null);
                writer.writeText((Object)"\n});\n", component, null);
            }
            writer.endElement("script");
        }
    }

    private String convertTooltipTriggerToJavaScriptEvent(String trigger) {
        if ("click".equalsIgnoreCase(trigger)) {
            return "click";
        }
        if ("focus".equalsIgnoreCase(trigger)) {
            return "focus";
        }
        if ("manual".equalsIgnoreCase(trigger)) {
            return "";
        }
        return "mouseenter mouseleave";
    }

    private void encodePopoverEvent(String forSelector, String function, String event, UIComponent component, ResponseWriter writer) throws IOException {
        if (StringUtils.isNotEmpty(function)) {
            writer.writeText((Object)"jQuery(document).ready(function() {\n", null);
            writer.writeText((Object)("    jQuery(" + forSelector + ").on('" + event + "', function() {\n "), component, null);
            writer.writeText((Object)("        " + function + ";\n"), component, null);
            writer.writeText((Object)"    });\n", component, null);
            writer.writeText((Object)"});\n", component, null);
        }
    }

    private void renderValidationErrors(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        Iterator clientIdsWithMessages = context.getClientIdsWithMessages();
        while (clientIdsWithMessages.hasNext()) {
            String clientIdWithMessages = (String)clientIdsWithMessages.next();
            if (!component.getClientId().equals(clientIdWithMessages)) continue;
            Iterator componentMessages = context.getMessages(clientIdWithMessages);
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"butter-component-tooltip-validation-error", null);
            writer.startElement("ul", component);
            while (componentMessages.hasNext()) {
                writer.startElement("li", component);
                writer.writeText((Object)((FacesMessage)componentMessages.next()).getDetail(), null);
                writer.endElement("li");
            }
            writer.endElement("ul");
            writer.endElement("div");
        }
    }

    private String getForElement(HtmlTooltip tooltip) {
        if (StringUtils.isNotEmpty(tooltip.getFor())) {
            return "'" + tooltip.getFor() + "'";
        }
        if (tooltip.getParent() instanceof Tooltip) {
            UIComponent parent = tooltip.getParent();
            if (parent instanceof Readonly && !(parent instanceof HtmlTags) && !(parent instanceof HtmlTreeBox) && ((Readonly)parent).isReadonly()) {
                return this.createParentReadonlyForElement(tooltip);
            }
            return this.createParentForElement(tooltip);
        }
        return null;
    }

    private String createParentReadonlyForElement(HtmlTooltip tooltip) {
        return this.createParentForElement(tooltip) + ").find('.butter-component-value-readonly-wrapper'";
    }

    private String createParentForElement(HtmlTooltip tooltip) {
        return "document.getElementById('" + tooltip.getParent().getClientId() + "')";
    }

    private boolean isTooltipParentReadonly(HtmlTooltip tooltip) {
        return tooltip.getParent() instanceof Tooltip && !(tooltip.getParent() instanceof HtmlTags) && tooltip.getParent() instanceof Readonly && ((Readonly)tooltip.getParent()).isReadonly();
    }

    private String getNullSafeStringParameter(String value) {
        return "'" + StringUtils.getNullSafeValue(value) + "'";
    }

    private String getNullSafeFunctionParameter(String value) {
        String nullSafeValue = StringUtils.getNullSafeValue(value);
        return StringUtils.isNotEmpty(nullSafeValue) ? nullSafeValue : "''";
    }

    private String getNullSafeIntegerParameter(Integer value) {
        return value == null ? "''" : String.valueOf(value);
    }
}

