/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.html.message.HtmlMessages;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.MessagesRenderer")
public class MessagesRenderer
extends HtmlBasicRenderer {
    private static final String ELEMENT_UL = "ul";
    private static final String ELEMENT_LI = "li";

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlMessages messagesComponent = (HtmlMessages)component;
        if (messagesComponent.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            StringBuffer styleClass = new StringBuffer();
            styleClass.append("butter-component-messages");
            if (messagesComponent.getStyleClass() != null) {
                styleClass.append(" ").append(messagesComponent.getStyleClass());
            }
            writer.writeAttribute("class", (Object)styleClass.toString(), null);
            if (messagesComponent.getStyle() != null) {
                writer.writeAttribute("style", (Object)messagesComponent.getStyle(), null);
            }
            List<FacesMessage> messages = StringUtils.isEmpty(messagesComponent.getFor()) ? this.getMessages(context, messagesComponent.isGlobalOnly()) : this.getMessagesForId(context, messagesComponent.getFor());
            List<FacesMessage> errorMessages = this.filterMessages(messages, FacesMessage.SEVERITY_ERROR, FacesMessage.SEVERITY_FATAL);
            List<FacesMessage> warnMessages = this.filterMessages(messages, FacesMessage.SEVERITY_WARN);
            List<FacesMessage> infoMessages = this.filterMessages(messages, FacesMessage.SEVERITY_INFO);
            this.renderMessageList(errorMessages, "alert alert-danger", writer, messagesComponent);
            this.renderMessageList(warnMessages, "alert alert-warning", writer, messagesComponent);
            this.renderMessageList(infoMessages, "alert alert-info", writer, messagesComponent);
            writer.endElement("div");
        }
        super.encodeEnd(context, component);
    }

    private List<FacesMessage> filterMessages(List<FacesMessage> globalMessages, FacesMessage.Severity ... severities) {
        List<FacesMessage.Severity> severityList = Arrays.asList(severities);
        ArrayList<FacesMessage> filteredMessages = new ArrayList<FacesMessage>();
        for (FacesMessage message : globalMessages) {
            if (!severityList.contains(message.getSeverity())) continue;
            filteredMessages.add(message);
        }
        return filteredMessages;
    }

    private void renderMessageList(List<FacesMessage> messages, String containerStyleClass, ResponseWriter writer, HtmlMessages component) throws IOException {
        if (!messages.isEmpty()) {
            writer.startElement("div", (UIComponent)component);
            writer.writeAttribute("class", (Object)containerStyleClass, null);
            writer.startElement(ELEMENT_UL, (UIComponent)component);
            for (FacesMessage facesMessage : messages) {
                writer.startElement(ELEMENT_LI, (UIComponent)component);
                this.renderMessagePart(writer, component, "summary", facesMessage.getSummary());
                if (facesMessage.getDetail() != null && component.isShowDetail()) {
                    this.renderMessagePart(writer, component, "detail", facesMessage.getDetail());
                }
                writer.endElement(ELEMENT_LI);
            }
            writer.endElement(ELEMENT_UL);
            writer.endElement("div");
        }
    }

    private void renderMessagePart(ResponseWriter writer, HtmlMessages component, String styleClass, String value) throws IOException {
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeText((Object)value, (UIComponent)component, null);
        writer.endElement("span");
    }

    private List<FacesMessage> getMessages(FacesContext context, boolean globalOnly) {
        ArrayList<FacesMessage> messages = new ArrayList<FacesMessage>();
        Iterator messageIter = globalOnly ? context.getMessages(null) : context.getMessages();
        while (messageIter.hasNext()) {
            messages.add((FacesMessage)messageIter.next());
        }
        return messages;
    }

    private List<FacesMessage> getMessagesForId(FacesContext context, String componentId) {
        ArrayList<FacesMessage> messages = new ArrayList<FacesMessage>();
        Iterator messageIter = context.getMessages(componentId);
        while (messageIter.hasNext()) {
            messages.add((FacesMessage)messageIter.next());
        }
        return messages;
    }
}

