/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.html.HtmlMarkdown;
import de.larmic.butterfaces.component.partrenderer.MaxLengthPartRenderer;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.MarkdownRenderer")
public class MarkdownRenderer
extends AbstractHtmlTagRenderer<HtmlMarkdown> {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component, "butter-component-markdown");
    }

    @Override
    protected String getHtmlTagName() {
        return "textarea";
    }

    @Override
    protected void encodeEnd(HtmlMarkdown markdown, ResponseWriter writer) throws IOException {
        new MaxLengthPartRenderer().renderMaxLength(markdown, writer);
        writer.startElement("script", (UIComponent)markdown);
        if (!markdown.isReadonly()) {
            writer.writeText((Object)RenderUtils.createJQueryPluginCall(markdown.getClientId(), "textarea", this.createJQueryMarkdownPluginCall(markdown)), null);
        } else {
            writer.writeText((Object)RenderUtils.createJQueryPluginCall(markdown.getClientId(), null, this.createJQueryMarkdownToHtmlPluginCall()), null);
        }
        writer.endElement("script");
        if (StringUtils.isNotEmpty(markdown.getPlaceholder()) && markdown.getPlaceholder().contains("\\n") && !markdown.isReadonly()) {
            RenderUtils.renderJQueryPluginCall(markdown.getClientId(), "multilinePlaceholder()", writer, (UIComponent)markdown);
        }
    }

    private String createJQueryMarkdownPluginCall(HtmlMarkdown markdown) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("markdown({");
        jQueryPluginCall.append("autofocus: false,");
        jQueryPluginCall.append("savable: false,");
        jQueryPluginCall.append("language: '" + markdown.getLanguage() + "'");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }

    private String createJQueryMarkdownToHtmlPluginCall() {
        return "markdownReadonly()";
    }
}

