/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.html.HtmlCheckBox;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.partrenderer.InnerComponentCheckBoxWrapperPartRenderer;
import de.larmic.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import de.larmic.butterfaces.util.StringJoiner;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.CheckBoxRenderer")
public class CheckBoxRenderer
extends AbstractHtmlTagRenderer<HtmlCheckBox> {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeBegin(context, component, "butter-component-checkbox");
    }

    @Override
    protected void encodeEndInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlCheckBox checkBox = (HtmlCheckBox)component;
        new InnerComponentCheckBoxWrapperPartRenderer().renderInnerWrapperEnd(checkBox, writer);
    }

    @Override
    protected void encodeBeginInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlCheckBox checkBox = (HtmlCheckBox)component;
        new InnerComponentCheckBoxWrapperPartRenderer().renderInnerWrapperBegin(checkBox, writer);
    }

    @Override
    protected void renderInputStyleClass(HtmlInputComponent component, ResponseWriter writer) throws IOException {
        String validationMarkerClass = !component.isValid() ? "butter-component-invalid" : null;
        String styleClass = StringJoiner.on(" ").join("butter-input-component").join(validationMarkerClass).toString();
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof HtmlCheckBox)) {
            return;
        }
        HtmlCheckBox checkBox = (HtmlCheckBox)component;
        if (!component.isRendered() || checkBox.isReadonly()) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        this.setSubmittedValue(component, CheckBoxRenderer.isChecked((String)requestMap.get(clientId)));
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue instanceof Boolean ? submittedValue : Boolean.valueOf(submittedValue.toString());
    }

    @Override
    protected void encodeTagType(UIComponent component, ResponseWriter writer) throws IOException {
        writer.writeAttribute("type", (Object)"checkbox", "type");
    }

    @Override
    protected void encodeAdditionalTagAttributes(UIComponent component, ResponseWriter writer, String currentValue) throws IOException {
        if (Boolean.valueOf(currentValue).booleanValue()) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
    }

    private static boolean isChecked(String value) {
        return "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }
}

