/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.partrenderer;

import de.larmic.butterfaces.component.html.HtmlTooltip;
import de.larmic.butterfaces.component.html.feature.Validation;
import de.larmic.butterfaces.component.html.text.HtmlCalendar;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class TooltipValidationRenderer {
    public void renderTooltipIfNecessary(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderTooltip(component)) {
            boolean tooltipRendered = false;
            for (UIComponent uiComponent : component.getChildren()) {
                if (!(uiComponent instanceof HtmlTooltip) || !uiComponent.isRendered()) continue;
                tooltipRendered = true;
                break;
            }
            if (!tooltipRendered) {
                HtmlTooltip htmlTooltip = new HtmlTooltip();
                if (component instanceof HtmlCalendar) {
                    htmlTooltip.setPlacement("auto top");
                }
                htmlTooltip.setParent(component);
                htmlTooltip.encodeAll(context);
            }
        }
    }

    private boolean shouldRenderTooltip(UIComponent component) {
        return component instanceof Validation && !((Validation)component).isValid();
    }
}

