/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.partrenderer;

import de.larmic.butterfaces.component.html.feature.AutoFocus;
import de.larmic.butterfaces.component.html.feature.Placeholder;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class HtmlAttributePartRenderer {
    public void renderHtmlFeatures(UIComponent component, ResponseWriter writer) throws IOException {
        AutoFocus autoFocus;
        if (component instanceof AutoFocus && (autoFocus = (AutoFocus)component).isAutoFocus()) {
            writer.writeAttribute("autofocus", (Object)"true", null);
        }
        if (component instanceof Placeholder) {
            Placeholder placeholder = (Placeholder)component;
            HtmlAttributePartRenderer htmlAttributePartRenderer = new HtmlAttributePartRenderer();
            htmlAttributePartRenderer.writePlaceholderAttribute(writer, placeholder.getPlaceholder());
        }
    }

    public void writePlaceholderAttribute(ResponseWriter writer, String attributeValue) throws IOException {
        this.writeHtmlAttributeIfNotEmpty(writer, "placeholder", attributeValue);
    }

    private void writeHtmlAttributeIfNotEmpty(ResponseWriter writer, String attributeName, String attributeValue) throws IOException {
        this.writeHtmlAttributeIfNotEmpty(writer, attributeName, attributeValue, null);
    }

    private void writeHtmlAttributeIfNotEmpty(ResponseWriter writer, String attributeName, String attributeValue, String alternativeValue) throws IOException {
        if (attributeValue != null && !"".equals(attributeValue)) {
            writer.writeAttribute(attributeName, (Object)attributeValue, attributeName);
        } else if (alternativeValue != null && !"".equals(alternativeValue)) {
            writer.writeAttribute(attributeName, (Object)alternativeValue, attributeName);
        }
    }
}

