/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.html.table.export.model;

import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.html.table.export.iterator.TableExportWriterTableListIterator;
import de.larmic.butterfaces.component.html.table.export.model.DataStream;
import de.larmic.butterfaces.component.html.table.export.writer.TableExportWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.model.ListDataModel;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class TableDataStream
implements DataStream {
    private static final Logger LOG = Logger.getLogger(TableDataStream.class.getName());
    private final HtmlTable table;
    private final List<HtmlColumn> columns;
    private final List<String> header;
    private final TableModelType tableModelType;
    private final List<?> listModel;
    private final boolean exportInvisibleColumns;
    private final TableExportWriter tableExportWriter;

    public TableDataStream(HtmlTable table, boolean exportInvisibleColumns, TableExportWriter tableExportWriter) {
        this.exportInvisibleColumns = exportInvisibleColumns;
        this.tableExportWriter = tableExportWriter;
        this.columns = this.getColumns(table);
        this.header = this.createHeader(this.columns);
        this.table = table;
        this.listModel = this.getListModel(table);
        if (this.listModel == null) {
            LOG.warning(String.format("Could not create export. Table model %s is not supported", table.getValue().getClass()));
            throw new RuntimeException("error.export.failed");
        }
        this.tableModelType = TableModelType.LIST_MODEL;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException, JAXBException, TransformerException, ParserConfigurationException {
        if (this.isResultsAvailable()) {
            if (this.tableModelType == TableModelType.LIST_MODEL) {
                this.tableExportWriter.write(outputStream, new TableExportWriterTableListIterator(this.header, this.listModel, this.columns, this.table.getVar()));
            } else {
                throw new IllegalArgumentException(String.format("Model %s is not supported ba TableDataStream", new Object[]{this.tableModelType}));
            }
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isResultsAvailable() {
        if (this.tableModelType == TableModelType.LIST_MODEL) {
            return !this.listModel.isEmpty();
        }
        throw new IllegalArgumentException(String.format("Model %s is not supported ba TableDataStream", new Object[]{this.tableModelType}));
    }

    private List<?> getListModel(HtmlTable table) {
        Object tableValue = table.getValue();
        if (tableValue instanceof ListDataModel) {
            return (List)((ListDataModel)tableValue).getWrappedData();
        }
        if (tableValue instanceof List) {
            return (List)tableValue;
        }
        return null;
    }

    private List<HtmlColumn> getColumns(HtmlTable table) {
        ArrayList<HtmlColumn> columns = new ArrayList<HtmlColumn>();
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof HtmlColumn) || ((HtmlColumn)child).isHideColumn() && !this.exportInvisibleColumns || !child.isRendered()) continue;
            columns.add((HtmlColumn)child);
        }
        return columns;
    }

    private List<String> createHeader(List<HtmlColumn> columns) {
        ArrayList<String> header = new ArrayList<String>();
        for (HtmlColumn column : columns) {
            String headerText = column.getLabel();
            if (headerText.startsWith("ID")) {
                headerText = headerText.replaceFirst("ID", "id");
            }
            header.add(headerText);
        }
        return header;
    }

    private static enum TableModelType {
        QUERY_MODEL,
        LIST_MODEL;

    }
}

