/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.html.repeat;

import de.larmic.butterfaces.component.html.repeat.ChildStateHolder;
import de.larmic.butterfaces.component.html.repeat.RowStatus;
import de.larmic.butterfaces.component.html.repeat.event.RowKeyEventBroadcaster;
import de.larmic.butterfaces.component.html.repeat.event.RowKeyFacesEvent;
import de.larmic.butterfaces.component.html.repeat.model.DataModelWrapper;
import de.larmic.butterfaces.component.html.repeat.model.DataModelWrapperFactory;
import de.larmic.butterfaces.component.html.repeat.visitor.ChildrenComponentVisitor;
import de.larmic.butterfaces.component.html.repeat.visitor.ChildrenTreeDataVisitor;
import de.larmic.butterfaces.component.html.repeat.visitor.ChildrenTreeDataVisitorCallback;
import de.larmic.butterfaces.component.html.repeat.visitor.DataVisitor;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public abstract class UIDataAdaptor
extends UIComponentBase
implements NamingContainer,
UniqueIdVendor,
ComponentSystemEventListener,
SystemEventListener,
ChildrenTreeDataVisitorCallback {
    private String PRE_RENDER_VIEW_EVENT_REGISTERED = UIDataAdaptor.class.getName() + ":preRenderViewEventRegistered";
    private static final Logger LOG = Logger.getLogger(UIDataAdaptor.class.getName());
    protected final char separatorChar;
    private DataModelWrapper<?> dataModelWrapper = null;
    private Integer rowKey = null;
    private String containerClientId;
    Stack<Object> originalVarValues = new Stack();

    public UIDataAdaptor() {
        this.subscribeToEvent(PostAddToViewEvent.class, this);
        this.subscribeToEvent(PostRestoreStateEvent.class, this);
        this.separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
    }

    public String createUniqueId(FacesContext context, String seed) {
        Integer i = (Integer)this.getStateHelper().get((Serializable)((Object)PropertyKeys.lastId));
        int lastId = i != null ? i : 0;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastId), (Object)(++lastId));
        return "j_id" + (seed == null ? Integer.valueOf(lastId) : seed);
    }

    public Integer getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(FacesContext facesContext, Integer rowKey) {
        this.saveChildState(facesContext);
        this.rowKey = rowKey;
        int rowKeyAsInt = rowKey != null ? rowKey : -1;
        this.getDataModelWrapper().setRowIndex(rowKeyAsInt);
        this.containerClientId = null;
        boolean rowSelected = rowKey != null && this.isRowAvailable();
        this.setupVariable(facesContext, rowSelected);
        this.restoreChildState(facesContext);
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent(this.wrapEvent(event));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof RowKeyFacesEvent) {
            RowKeyEventBroadcaster.broadcast(this.getFacesContext(), (RowKeyFacesEvent)event);
        } else {
            super.broadcast(event);
        }
    }

    private Map<String, Object> getVariablesMap(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap();
    }

    private void saveChildState(FacesContext facesContext) {
        Iterator<UIComponent> itr = this.dataChildren();
        while (itr.hasNext()) {
            this.saveChildState(facesContext, itr.next());
        }
    }

    private void saveChildState(FacesContext facesContext, UIComponent component) {
        if (component.isTransient()) {
            return;
        }
        ChildStateHolder childStateHolder = null;
        if (component instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)component;
            childStateHolder = new ChildStateHolder(evh);
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            childStateHolder = new ChildStateHolder(form);
        }
        if (childStateHolder != null) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.childState), component.getClientId(facesContext), (Object)childStateHolder);
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.saveChildState(facesContext, child);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveChildState(facesContext, facet);
            }
        }
    }

    @Override
    public Iterator<UIComponent> dataChildren() {
        if (this.getChildCount() > 0) {
            return this.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    private void restoreChildState(FacesContext facesContext) {
        Iterator<UIComponent> itr = this.dataChildren();
        while (itr.hasNext()) {
            this.restoreChildState(facesContext, itr.next());
        }
    }

    private void restoreChildState(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        component.setId(id);
        ChildStateHolder childStateHolder = null;
        Map savedStatesMap = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.childState));
        if (savedStatesMap != null) {
            childStateHolder = (ChildStateHolder)savedStatesMap.get(component.getClientId(facesContext));
        }
        if (childStateHolder == null) {
            childStateHolder = ChildStateHolder.EMPTY;
        }
        if (component instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)component;
            childStateHolder.apply(evh);
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            childStateHolder.apply(form);
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.restoreChildState(facesContext, child);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreChildState(facesContext, facet);
            }
        }
    }

    private FacesEvent wrapEvent(FacesEvent event) {
        return new RowKeyFacesEvent(this, event, this.getRowKey());
    }

    private DataModelWrapper<?> getDataModelWrapper() {
        if (this.dataModelWrapper == null) {
            this.dataModelWrapper = DataModelWrapperFactory.createDataModelWrapper(this.getValue());
        }
        return this.dataModelWrapper;
    }

    public int getRowIndex() {
        return this.getDataModelWrapper().getRowIndex();
    }

    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)var);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.resetDataModel();
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    public String getStatus() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.status));
    }

    public void setStatus(String status) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.status), (Object)status);
    }

    public int getRowCount() {
        return this.getDataModelWrapper().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModelWrapper().getRowData();
    }

    @Override
    public boolean isRowAvailable() {
        return this.getDataModelWrapper().isRowAvailable();
    }

    private void setupVariable(FacesContext faces, boolean rowSelected) {
        Map<String, Object> attrs = this.getVariablesMap(faces);
        if (rowSelected) {
            this.setupVariable(this.getVar(), attrs, this.getRowData());
        } else {
            this.removeVariable(this.getVar(), attrs);
        }
        String iterationStatusVar = this.getStatus();
        if (iterationStatusVar != null) {
            Map<String, Object> requestMap = this.getVariablesMap(faces);
            if (rowSelected) {
                RowStatus iterationStatus = new RowStatus(this.getRowIndex(), this.getRowCount());
                requestMap.put(iterationStatusVar, iterationStatus);
            } else {
                requestMap.remove(iterationStatusVar);
            }
        }
    }

    private void setupVariable(String var, Map<String, Object> attrs, Object rowData) {
        if (var != null) {
            attrs.put(var, rowData);
        }
    }

    private void removeVariable(String var, Map<String, Object> attrs) {
        if (var != null) {
            attrs.remove(var);
        }
    }

    public String getContainerClientId(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException("context");
        }
        if (null == this.containerClientId) {
            this.containerClientId = super.getContainerClientId(facesContext);
            Integer rowKey = this.getRowKey();
            if (rowKey != null) {
                this.containerClientId = this.containerClientId + this.separatorChar + rowKey;
            }
        }
        return this.containerClientId;
    }

    public void restoreOrigValue(FacesContext faces) {
        String iterationStatusVar;
        String var = this.getVar();
        if (var != null) {
            Map<String, Object> attrs = this.getVariablesMap(faces);
            if (!this.originalVarValues.isEmpty()) {
                attrs.put(var, this.originalVarValues.pop());
            } else {
                attrs.remove(var);
            }
        }
        if ((iterationStatusVar = this.getStatus()) != null) {
            Map<String, Object> variablesMap = this.getVariablesMap(faces);
            variablesMap.remove(iterationStatusVar);
        }
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if ("value".equals(name)) {
            this.resetDataModel();
        }
        if ("var".equals(name) || "rowKeyVar".equals(name) || "stateVar".equals(name)) {
            throw new IllegalArgumentException(MessageFormat.format("{0} cannot be EL-expression", name));
        }
        super.setValueExpression(name, binding);
    }

    private boolean keepSaved(FacesContext context) {
        FacesMessage.Severity maximumSeverity = context.getMaximumSeverity();
        return maximumSeverity != null && FacesMessage.SEVERITY_ERROR.compareTo((Object)maximumSeverity) <= 0;
    }

    public void walk(FacesContext faces, DataVisitor visitor) throws IOException {
        this.getDataModelWrapper().walk(faces, visitor);
        this.restoreOrigValue(faces);
    }

    public void setId(String id) {
        super.setId(id);
        this.containerClientId = null;
    }

    public void resetDataModel() {
        this.dataModelWrapper = null;
    }

    protected void resetChildState() {
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.childState));
    }

    private void resetState() {
        this.dataModelWrapper = null;
        if (!this.keepSaved(this.getFacesContext())) {
            this.resetChildState();
        }
    }

    public Object saveState(FacesContext context) {
        Object parentState = super.saveState(context);
        if (this.initialStateMarked() && parentState == null) {
            return null;
        }
        return new Object[]{parentState};
    }

    public void restoreState(FacesContext context, Object stateObject) {
        if (stateObject == null) {
            return;
        }
        super.restoreState(context, ((Object[])stateObject)[0]);
    }

    private boolean matchesBaseId(String clientId, String baseId, char separatorChar) {
        return clientId.equals(baseId) || clientId.startsWith(baseId) && clientId.length() > baseId.length() && clientId.charAt(baseId.length()) == separatorChar;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        String baseId = this.getClientId(context);
        if (!this.matchesBaseId(clientId, baseId, this.separatorChar)) {
            return false;
        }
        boolean found = false;
        Integer oldRowKey = this.getRowKey();
        try {
            if (clientId.equals(baseId)) {
                callback.invokeContextCallback(context, (UIComponent)this);
                found = true;
            }
            if (!found) {
                this.setRowKey(context, null);
                if (this.isRowAvailable()) {
                    Iterator<UIComponent> dataChildrenItr = this.dataChildren();
                    while (dataChildrenItr.hasNext() && !found) {
                        UIComponent dataChild = dataChildrenItr.next();
                        found = dataChild.invokeOnComponent(context, clientId, callback);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            try {
                this.setRowKey(context, oldRowKey);
                this.restoreOrigValue(context);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return found;
    }

    private boolean visitComponents(Iterator<UIComponent> components, VisitContext context, VisitCallback callback) {
        while (components.hasNext()) {
            UIComponent nextChild = components.next();
            if (!nextChild.visitTree(context, callback)) continue;
            return true;
        }
        return false;
    }

    protected boolean visitDataChildren(VisitContext visitContext, VisitCallback callback, boolean visitRows) throws IOException {
        if (visitRows) {
            FacesContext facesContext = visitContext.getFacesContext();
            ChildrenTreeDataVisitor dataVisitor = new ChildrenTreeDataVisitor(callback, visitContext, this);
            this.walk(facesContext, dataVisitor);
            return dataVisitor.getVisitResult();
        }
        return this.visitComponents(this.getFacetsAndChildren(), visitContext, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        if (!this.isVisitable(visitContext)) {
            return false;
        }
        FacesContext facesContext = visitContext.getFacesContext();
        boolean visitRows = this.requiresRowIteration(visitContext);
        Integer oldRowKey = null;
        if (visitRows) {
            oldRowKey = this.getRowKey();
            this.setRowKey(facesContext, null);
        }
        this.pushComponentToEL(facesContext, null);
        try {
            VisitResult result = visitContext.invokeVisitCallback((UIComponent)this, callback);
            if (result == VisitResult.COMPLETE) {
                boolean bl = true;
                return bl;
            }
            if (result == VisitResult.ACCEPT && this.visitDataChildren(visitContext, callback, visitRows)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.popComponentFromEL(facesContext);
            if (visitRows) {
                try {
                    this.setRowKey(facesContext, oldRowKey);
                    this.restoreOrigValue(facesContext);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return false;
    }

    private boolean requiresRowIteration(VisitContext context) {
        return !context.getHints().contains(VisitHint.SKIP_ITERATION);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        this.processEvent((SystemEvent)event);
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostAddToViewEvent) {
            this.subscribeToPreRenderViewEventOncePerRequest();
        } else if (event instanceof PostRestoreStateEvent) {
            this.subscribeToPreRenderViewEventOncePerRequest();
            this.resetState();
        } else if (event instanceof PreRenderViewEvent) {
            this.resetState();
        }
    }

    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(faces, (UIComponent)this);
        this.walkThroughChildren(faces, new ChildrenComponentVisitor(this){

            @Override
            public void processComponent(FacesContext context, UIComponent component) {
                component.processDecodes(context);
            }
        });
        this.decode(faces);
        this.popComponentFromEL(faces);
    }

    private void walkThroughChildren(FacesContext faces, ChildrenComponentVisitor visitor) {
        if (!this.isRendered()) {
            return;
        }
        String var = this.getVar();
        if (var != null) {
            Map<String, Object> attrs = this.getVariablesMap(faces);
            this.originalVarValues.push(attrs.get(var));
        }
        this.setRowKey(faces, null);
        try {
            this.walk(faces, visitor);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.setRowKey(faces, null);
            this.restoreOrigValue(faces);
        }
    }

    private void subscribeToPreRenderViewEventOncePerRequest() {
        FacesContext facesContext = this.getFacesContext();
        Map contextMap = facesContext.getAttributes();
        if (contextMap.get(this.getClientId() + this.PRE_RENDER_VIEW_EVENT_REGISTERED) == null) {
            contextMap.put(this.getClientId() + this.PRE_RENDER_VIEW_EVENT_REGISTERED, Boolean.TRUE);
            UIViewRoot viewRoot = facesContext.getViewRoot();
            viewRoot.subscribeToViewEvent(PreRenderViewEvent.class, (SystemEventListener)this);
        }
    }

    public boolean isListenerForSource(Object source) {
        return this.equals(source) || source instanceof UIViewRoot;
    }

    private static enum PropertyKeys {
        lastId,
        var,
        stateVar,
        childState,
        first,
        rows,
        value,
        status;

    }
}

