/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.base.renderer;

import de.larmic.butterfaces.component.behavior.JsfAjaxRequest;
import de.larmic.butterfaces.component.html.feature.Readonly;
import de.larmic.butterfaces.resolver.ClientBehaviorResolver;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;

public class HtmlBasicRenderer
extends Renderer {
    public static final String ELEMENT_DIV = "div";
    public static final String ELEMENT_SPAN = "span";
    public static final String ELEMENT_SECTION = "section";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_PLACEHOLDER = "placeholder";

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.encodeRecursive(context, child);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        this.getEndTextToRender(context, component, this.getCurrentValue(context, component));
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        return facet != null && facet.isRendered() ? facet : null;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (!component.isRendered() || component instanceof Readonly && ((Readonly)component).isReadonly()) {
            return;
        }
        if (!(component instanceof UIInput)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        this.setSubmittedValue(component, context.getExternalContext().getRequestParameterMap().get(clientId));
    }

    protected final String decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder holder = (ClientBehaviorHolder)component;
        Map behaviors = holder.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return null;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && behaviorsForEvent.size() > 0) {
            String clientId;
            String behaviorSource = (String)params.get("javax.faces.source");
            if (this.isBehaviorSource(behaviorSource, clientId = component.getClientId())) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
            return clientId;
        }
        return null;
    }

    protected boolean isBehaviorSource(String behaviorSourceId, String componentClientId) {
        return behaviorSourceId != null && behaviorSourceId.equals(componentClientId);
    }

    protected void setSubmittedValue(UIComponent component, Object value) {
        if (component instanceof UIInput) {
            ((UIInput)component).setSubmittedValue(value);
        }
    }

    protected void renderBooleanValue(UIComponent component, ResponseWriter writer, String attributeName) throws IOException {
        if (component.getAttributes().get(attributeName) != null && Boolean.valueOf(component.getAttributes().get(attributeName).toString()).booleanValue()) {
            writer.writeAttribute(attributeName, (Object)true, attributeName);
        }
    }

    protected void renderStringValue(UIComponent component, ResponseWriter writer, String attributeName) throws IOException {
        if (component.getAttributes().get(attributeName) != null && StringUtils.isNotEmpty(component.getAttributes().get(attributeName).toString()) && this.shouldRenderAttribute(component.getAttributes().get(attributeName))) {
            writer.writeAttribute(attributeName, (Object)component.getAttributes().get(attributeName).toString().trim(), attributeName);
        }
    }

    protected void renderStringValue(UIComponent component, ResponseWriter writer, String attributeName, String matchingValue) throws IOException {
        if (component.getAttributes().get(attributeName) != null && matchingValue.equalsIgnoreCase(component.getAttributes().get(attributeName).toString()) && this.shouldRenderAttribute(component.getAttributes().get(attributeName))) {
            writer.writeAttribute(attributeName, (Object)matchingValue, attributeName);
        }
    }

    protected void renderEventValue(UIComponent component, ResponseWriter writer, String attributeName, String eventName) throws IOException {
        String componentEventFunction = this.createComponentEventFunction(component, attributeName);
        String ajaxEventFunction = this.createAjaxEventFunction((UIComponentBase)component, eventName);
        if (componentEventFunction != null && ajaxEventFunction != null) {
            writer.writeAttribute(attributeName, (Object)(ajaxEventFunction + ";" + componentEventFunction), null);
        } else if (componentEventFunction != null) {
            writer.writeAttribute(attributeName, (Object)componentEventFunction, null);
        } else if (ajaxEventFunction != null) {
            writer.writeAttribute(attributeName, (Object)ajaxEventFunction, null);
        }
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return submittedValue.toString();
        }
        if (component instanceof ValueHolder) {
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            Converter converter = valueHolder.getConverter();
            if (converter != null && value != null) {
                return converter.getAsString(context, component, value);
            }
            if (value != null) {
                return value.toString();
            }
        }
        return null;
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected String writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        if (this.shouldWriteIdAttribute(component)) {
            return this.writeIdAttribute(context, writer, component);
        }
        return null;
    }

    protected String writeIdAttribute(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        writer.writeAttribute(ATTRIBUTE_ID, (Object)clientId, ATTRIBUTE_ID);
        return clientId;
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)component).getClientBehaviors().isEmpty());
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator<UIComponent> childComponentsIterator = this.getChildren(component);
            while (childComponentsIterator.hasNext()) {
                this.encodeRecursive(context, childComponentsIterator.next());
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator<UIComponent> getChildren(UIComponent component) {
        if (component.getChildCount() > 0) {
            return component.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected String createComponentEventFunction(UIComponent component, String attributeName) {
        return component.getAttributes().get(attributeName) instanceof String ? (String)component.getAttributes().get(attributeName) : null;
    }

    private String createAjaxEventFunction(UIComponentBase component, String eventName) {
        AjaxBehavior ajaxBehavior = ClientBehaviorResolver.resolveActiveAjaxBehavior(component, eventName);
        return ajaxBehavior != null ? new JsfAjaxRequest(component, ajaxBehavior, eventName).toString() : null;
    }
}

