/*
 * Decompiled with CFR 0.152.
 */
package de.kherud.llama;

import de.kherud.llama.InferenceParameters;
import de.kherud.llama.LlamaException;
import de.kherud.llama.LlamaIterable;
import de.kherud.llama.LlamaIterator;
import de.kherud.llama.LlamaLoader;
import de.kherud.llama.LlamaOutput;
import de.kherud.llama.LogLevel;
import de.kherud.llama.ModelParameters;
import de.kherud.llama.args.LogFormat;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class LlamaModel
implements AutoCloseable {
    private long ctx;

    public LlamaModel(ModelParameters parameters) {
        this.loadModel(parameters.toString());
    }

    public String complete(InferenceParameters parameters) {
        parameters.setStream(false);
        int taskId = this.requestCompletion(parameters.toString());
        LlamaOutput output = this.receiveCompletion(taskId);
        return output.text;
    }

    public LlamaIterable generate(InferenceParameters parameters) {
        return () -> new LlamaIterator(this, parameters);
    }

    public native float[] embed(String var1);

    public native int[] encode(String var1);

    public String decode(int[] tokens) {
        byte[] bytes = this.decodeBytes(tokens);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static native void setLogger(LogFormat var0, @Nullable BiConsumer<LogLevel, String> var1);

    @Override
    public void close() {
        this.delete();
    }

    native int requestCompletion(String var1) throws LlamaException;

    native LlamaOutput receiveCompletion(int var1) throws LlamaException;

    native void cancelCompletion(int var1);

    native byte[] decodeBytes(int[] var1);

    private native void loadModel(String var1) throws LlamaException;

    private native void delete();

    static {
        LlamaLoader.initialize();
    }
}

