/*
 * Decompiled with CFR 0.152.
 */
package org.scannotation.archiveiterator;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.scannotation.archiveiterator.DirectoryIteratorFactory;
import org.scannotation.archiveiterator.FileIterator;
import org.scannotation.archiveiterator.Filter;
import org.scannotation.archiveiterator.JarIterator;
import org.scannotation.archiveiterator.StreamIterator;

public class FileProtocolIteratorFactory
implements DirectoryIteratorFactory {
    @Override
    public StreamIterator create(URL url, Filter filter) throws IOException {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        if (f.isDirectory()) {
            return new FileIterator(f, filter);
        }
        return new JarIterator(url.openStream(), filter);
    }
}

