/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.acronymtagger.main;

import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.Annotation;
import java.util.Stack;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class ConsistencyAnnotator {
    public void consistencyAnnotate(JCas aJCas) {
        Abbreviation tempAbbr;
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        FSIterator acronymIter = indexes.getAnnotationIndex(Abbreviation.type).iterator();
        String documenttext = aJCas.getDocumentText();
        Stack<Abbreviation> stack = new Stack<Abbreviation>();
        while (acronymIter.hasNext()) {
            Abbreviation abbr = (Abbreviation)acronymIter.next();
            String shortformtext = abbr.getCoveredText();
            String fullformtext = abbr.getExpan();
            Annotation textRef = abbr.getTextReference();
            int abbrPos = abbr.getBegin();
            int pos = 0;
            while ((pos = documenttext.indexOf(shortformtext, pos)) >= 0) {
                if (pos != abbrPos) {
                    tempAbbr = new Abbreviation(aJCas, pos, pos + shortformtext.length());
                    tempAbbr.setExpan(fullformtext);
                    tempAbbr.setDefinedHere(false);
                    tempAbbr.setTextReference(textRef);
                    stack.push(tempAbbr);
                }
                ++pos;
            }
            if (!shortformtext.matches("^[a-z]*[A-Z][A-Z]+s$")) continue;
            shortformtext = shortformtext.substring(0, shortformtext.length() - 1);
            pos = 0;
            while ((pos = documenttext.indexOf(shortformtext, pos)) >= 0) {
                if (pos != abbrPos) {
                    tempAbbr = new Abbreviation(aJCas, pos, pos + shortformtext.length());
                    tempAbbr.setExpan(fullformtext);
                    tempAbbr.setDefinedHere(false);
                    tempAbbr.setTextReference(textRef);
                    stack.push(tempAbbr);
                }
                ++pos;
            }
        }
        int begin = 0;
        int end = 0;
        while (!stack.empty()) {
            tempAbbr = (Abbreviation)stack.pop();
            begin = tempAbbr.getBegin();
            end = tempAbbr.getEnd();
            tempAbbr.addToIndexes();
        }
    }
}

