/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.acronymtagger.entries;

import de.julielab.jcore.ae.acronymtagger.entries.FullformEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AcronymEntry
implements Serializable {
    static final long serialVersionUID = 2L;
    private TreeMap<String, FullformEntry> fullformList = new TreeMap();

    protected AcronymEntry(String full) {
        FullformEntry x = new FullformEntry();
        this.addFullform(full, x);
    }

    protected AcronymEntry(String full, int year, Set<String> mesh, Set<String> unnormalizedFulls) {
        FullformEntry x = new FullformEntry(year, mesh, unnormalizedFulls);
        this.addFullform(full, x);
    }

    protected AcronymEntry(String fullName, FullformEntry ffE) {
        this.addFullform(fullName, ffE);
    }

    public boolean hasfullform(String full) {
        return this.fullformList.containsKey(full);
    }

    public Set<Map.Entry<String, FullformEntry>> getAllFullforms() {
        return this.fullformList.entrySet();
    }

    public void addFullform(String fullName, FullformEntry f) {
        if (!this.fullformList.containsKey(fullName)) {
            this.fullformList.put(fullName, f);
        } else {
            FullformEntry old = this.fullformList.get(fullName);
            old.meshTerms.addAll(f.meshTerms);
            old.unnormalizedForms.addAll(f.unnormalizedForms);
            FullformEntry newForm = new FullformEntry(Math.min(old.year, f.year), old.count + f.count, old.meshTerms, old.unnormalizedForms);
            this.fullformList.remove(fullName);
            this.fullformList.put(fullName, newForm);
        }
    }

    public void merge(String ffToKeep, String ffEntryToInclude) throws NullPointerException {
        FullformEntry representative = new FullformEntry();
        FullformEntry additional = new FullformEntry();
        try {
            representative = this.fullformList.get(ffToKeep);
            additional = this.fullformList.get(ffEntryToInclude);
            if (representative == null || additional == null) {
                throw new Exception();
            }
            representative.meshTerms.addAll(additional.meshTerms);
            representative.unnormalizedForms.addAll(additional.unnormalizedForms);
            representative.unnormalizedForms.add(ffEntryToInclude);
            HashSet<String> newUnnormFull = new HashSet<String>(representative.unnormalizedForms);
            FullformEntry newForm = new FullformEntry(Math.min(representative.year, additional.year), representative.count + additional.count, representative.meshTerms, representative.unnormalizedForms);
            this.fullformList.remove(ffToKeep);
            this.fullformList.remove(ffEntryToInclude);
            this.fullformList.put(ffToKeep, newForm);
        }
        catch (Exception e) {
            throw new NullPointerException("This AcronymEntry does not contain at least one of the specified fullforms");
        }
    }

    public void remove(String fullform) {
        this.fullformList.remove(fullform);
    }

    public String getString(String shortform) {
        StringBuffer s = new StringBuffer("");
        for (Map.Entry<String, FullformEntry> entry : this.fullformList.entrySet()) {
            FullformEntry f = entry.getValue();
            String fName = entry.getKey();
            s.append(String.valueOf(shortform) + "\t" + fName + f.getString());
        }
        return s.toString();
    }

    public String getHTMLString(String shortform, boolean includeMeshs) {
        Set<Map.Entry<String, FullformEntry>> flEntries = this.fullformList.entrySet();
        int entryNumber = flEntries.size();
        Iterator<Map.Entry<String, FullformEntry>> fullformIter = flEntries.iterator();
        StringBuffer s = new StringBuffer("\t<tr><th rowspan=\"" + entryNumber + "\">" + shortform + "</th>\n");
        Map.Entry<String, FullformEntry> entry = fullformIter.next();
        FullformEntry f = entry.getValue();
        String fName = entry.getKey();
        s.append("<td>" + fName + "</td>" + f.getHTMLString(includeMeshs) + "</tr>\n");
        while (fullformIter.hasNext()) {
            entry = fullformIter.next();
            f = entry.getValue();
            fName = entry.getKey();
            s.append("<tr><td>" + fName + "</td>" + f.getHTMLString(includeMeshs) + "</tr>\n");
        }
        return s.toString();
    }

    public int size() {
        return this.fullformList.size();
    }
}

