/*
 * Decompiled with CFR 0.152.
 */
package de.jjohannes.gradle.javamodules;

import de.jjohannes.gradle.javamodules.ModuleInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

public abstract class ExtraModuleInfoTransform
implements TransformAction<Parameter> {
    @InputArtifact
    protected abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        Map moduleInfo = ((Parameter)this.getParameters()).moduleInfo;
        Map automaticModules = ((Parameter)this.getParameters()).automaticModules;
        File originalJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        String originalJarName = originalJar.getName();
        if (this.isModule(originalJar)) {
            outputs.file((Object)originalJar);
        } else if (moduleInfo.containsKey(originalJarName)) {
            ExtraModuleInfoTransform.addModuleDescriptor(originalJar, this.getModuleJar(outputs, originalJar), (ModuleInfo)moduleInfo.get(originalJarName));
        } else if (this.isAutoModule(originalJar)) {
            outputs.file((Object)originalJar);
        } else if (automaticModules.containsKey(originalJarName)) {
            ExtraModuleInfoTransform.addAutomaticModuleName(originalJar, this.getModuleJar(outputs, originalJar), (String)automaticModules.get(originalJarName));
        } else {
            throw new RuntimeException("Not a module and no mapping defined: " + originalJarName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModule(File jar) {
        Pattern moduleInfoClassMrjarPath = Pattern.compile("META-INF/versions/\\d+/module-info.class");
        try (JarInputStream inputStream = new JarInputStream(new FileInputStream(jar));){
            boolean isMultiReleaseJar = this.containsMultiReleaseJarEntry(inputStream);
            ZipEntry next = inputStream.getNextEntry();
            while (next != null) {
                if ("module-info.class".equals(next.getName())) {
                    boolean bl = true;
                    return bl;
                }
                if (isMultiReleaseJar && moduleInfoClassMrjarPath.matcher(next.getName()).matches()) {
                    boolean bl = true;
                    return bl;
                }
                next = inputStream.getNextEntry();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsMultiReleaseJarEntry(JarInputStream jarStream) {
        Manifest manifest = jarStream.getManifest();
        return manifest != null && Boolean.parseBoolean(manifest.getMainAttributes().getValue("Multi-Release"));
    }

    private boolean isAutoModule(File jar) {
        boolean bl;
        JarInputStream inputStream = new JarInputStream(new FileInputStream(jar));
        try {
            bl = inputStream.getManifest().getMainAttributes().getValue("Automatic-Module-Name") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return bl;
    }

    private File getModuleJar(TransformOutputs outputs, File originalJar) {
        return outputs.file((Object)(originalJar.getName().substring(0, originalJar.getName().lastIndexOf(46)) + "-module.jar"));
    }

    private static void addAutomaticModuleName(File originalJar, File moduleJar, String moduleName) {
        try (JarInputStream inputStream = new JarInputStream(new FileInputStream(originalJar));){
            Manifest manifest = inputStream.getManifest();
            manifest.getMainAttributes().put(new Attributes.Name("Automatic-Module-Name"), moduleName);
            try (JarOutputStream outputStream = new JarOutputStream((OutputStream)new FileOutputStream(moduleJar), inputStream.getManifest());){
                ExtraModuleInfoTransform.copyEntries(inputStream, outputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addModuleDescriptor(File originalJar, File moduleJar, ModuleInfo moduleInfo) {
        try (JarInputStream inputStream = new JarInputStream(new FileInputStream(originalJar));
             JarOutputStream outputStream = new JarOutputStream((OutputStream)new FileOutputStream(moduleJar), inputStream.getManifest());){
            ExtraModuleInfoTransform.copyEntries(inputStream, outputStream);
            outputStream.putNextEntry(new JarEntry("module-info.class"));
            outputStream.write(ExtraModuleInfoTransform.addModuleInfo(moduleInfo));
            outputStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyEntries(JarInputStream inputStream, JarOutputStream outputStream) throws IOException {
        JarEntry jarEntry = inputStream.getNextJarEntry();
        while (jarEntry != null) {
            outputStream.putNextEntry(jarEntry);
            outputStream.write(inputStream.readAllBytes());
            outputStream.closeEntry();
            jarEntry = inputStream.getNextJarEntry();
        }
    }

    private static byte[] addModuleInfo(ModuleInfo moduleInfo) {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(53, 32768, "module-info", null, null, null);
        ModuleVisitor moduleVisitor = classWriter.visitModule(moduleInfo.getModuleName(), 32, moduleInfo.getModuleVersion());
        for (String packageName : moduleInfo.getExports()) {
            moduleVisitor.visitExport(packageName.replace('.', '/'), 0, new String[0]);
        }
        moduleVisitor.visitRequire("java.base", 0, null);
        for (String requireName : moduleInfo.getRequires()) {
            moduleVisitor.visitRequire(requireName, 0, null);
        }
        for (String requireName : moduleInfo.getRequiresTransitive()) {
            moduleVisitor.visitRequire(requireName, 32, null);
        }
        moduleVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    public static class Parameter
    implements TransformParameters,
    Serializable {
        private Map<String, ModuleInfo> moduleInfo = Collections.emptyMap();
        private Map<String, String> automaticModules = Collections.emptyMap();

        @Input
        public Map<String, ModuleInfo> getModuleInfo() {
            return this.moduleInfo;
        }

        @Input
        public Map<String, String> getAutomaticModules() {
            return this.automaticModules;
        }

        public void setModuleInfo(Map<String, ModuleInfo> moduleInfo) {
            this.moduleInfo = moduleInfo;
        }

        public void setAutomaticModules(Map<String, String> automaticModules) {
            this.automaticModules = automaticModules;
        }
    }
}

