/*
 * Decompiled with CFR 0.152.
 */
package de.jjohannes.maven.gmm;

import de.jjohannes.maven.gmm.Capability;
import de.jjohannes.maven.gmm.GradleModuleMetadataWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Properties;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="gmm", defaultPhase=LifecyclePhase.PACKAGE)
public class GradleModuleMetadataMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    protected List<Dependency> platformDependencies;
    @Parameter
    protected List<Capability> capabilities;
    @Parameter(defaultValue="${project.build.directory}/publications/maven")
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.assertMarkerCommentDefinedInPom();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File moduleFile = new File(this.outputDirectory, "module.json");
        try (FileWriter fileWriter = new FileWriter(moduleFile);){
            GradleModuleMetadataWriter.generateTo(this.project, GradleModuleMetadataMojo.getMavenVersion(), this.platformDependencies, this.capabilities, fileWriter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + moduleFile, (Exception)e);
        }
        DefaultArtifact gmmArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "module", null, (ArtifactHandler)new DefaultArtifactHandler("module"));
        gmmArtifact.setFile(moduleFile);
        this.project.addAttachedArtifact((Artifact)gmmArtifact);
    }

    private void assertMarkerCommentDefinedInPom() {
        String marker = "<!-- do_not_remove: published-with-gradle-metadata -->";
        File pomFile = this.project.getFile();
        try {
            if (Files.lines(pomFile.toPath()).noneMatch(line -> line.contains(marker))) {
                System.out.println(marker);
                throw new RuntimeException("Please add the Gradle Module Metadata marker '<!-- do_not_remove: published-with-gradle-metadata -->' to " + pomFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMavenVersion() throws MojoExecutionException {
        String string;
        block10: {
            InputStream resource = Maven.class.getClassLoader().getResourceAsStream("org/apache/maven/messages/build.properties");
            try {
                if (resource == null) {
                    throw new MojoExecutionException("Unable to determine Maven version.");
                }
                Properties properties = new Properties();
                properties.load(resource);
                String version = properties.getProperty("version");
                if (version == null) {
                    throw new MojoExecutionException("Unable to determine Maven version.");
                }
                string = version;
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to determine Maven version.", (Exception)e);
                }
            }
            resource.close();
        }
        return string;
    }
}

