/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.core.scope;

import com.github.libxjava.concurrent.AbstractSingleThreadRunner;
import com.github.libxjava.lang.IClassLoader;
import de.jiac.micro.core.IContainer;
import de.jiac.micro.core.IContainerConfiguration;
import de.jiac.micro.core.IScope;
import de.jiac.micro.core.LifecycleHandler;
import de.jiac.micro.core.handle.IReflector;
import de.jiac.micro.core.scope.IScopeAwareThread;
import de.jiac.micro.core.scope.IScopeMemory;
import de.jiac.micro.core.scope.ScopeImplBinder;
import org.slf4j.Logger;

public class Scope
implements IScope {
    private final IScopeMemory _memory = ScopeImplBinder.createScopeMemory((Scope)this, (long)0x100000L);
    private final ScopeRunner _runner;

    public static Scope getScope() throws IllegalThreadStateException {
        Thread thread = Thread.currentThread();
        if (thread instanceof IScopeAwareThread) {
            return ((IScopeAwareThread)((Object)thread)).getScope();
        }
        Scope result = ScopeImplBinder.guessScope();
        if (result != null) {
            return result;
        }
        throw new IllegalThreadStateException("Current thread is not context aware: " + thread.toString());
    }

    protected static Scope getScope(Class scopeType) throws IllegalThreadStateException {
        Scope result = Scope.getScope();
        if (result == null || result.getClass() != scopeType) {
            throw new IllegalThreadStateException("Current thread is not allowed to access " + scopeType.getName());
        }
        return result;
    }

    public static Thread createScopeAwareThread(Scope scope, Runnable target, String name) {
        return ScopeImplBinder.createScopeAwareThread((Scope)scope, (Runnable)target, (String)name);
    }

    public static final Thread createScopeAwareThread(Runnable target, String name) {
        return ScopeImplBinder.createScopeAwareThread((Scope)Scope.getScope(), (Runnable)target, (String)name);
    }

    public static final IContainer getContainer() {
        return Scope.getScope().getContainerReference();
    }

    public static final void executeInScope(Runnable runnable) {
        ScopeImplBinder.executeInScope((Runnable)runnable);
    }

    protected Scope(String runnerName, Class configurationSuperClass) {
        this._runner = new ScopeRunner(runnerName, configurationSuperClass);
    }

    public final IScopeMemory getScopeMemory() {
        return this._memory;
    }

    public final IContainer getContainerReference() {
        LifecycleHandler.SimpleLifecycleContext scopeContext = (LifecycleHandler.SimpleLifecycleContext)this._memory.getReference();
        if (scopeContext == null) {
            throw new RuntimeException("Scope is not active");
        }
        return (IContainer)((Object)scopeContext.lifecycleAware());
    }

    public final void signal(byte signal) {
        if (this._runner.isInState((byte)1)) {
            this._runner.communicateSignal(signal);
        }
    }

    public final void setup(IClassLoader classLoader, String configurationClassName, IScope.IScopeStateChangeListener listener) {
        if (!this._runner.isInState((byte)2)) {
            throw new IllegalThreadStateException("This scope is still active.");
        }
        this._runner.classLoader = classLoader;
        this._runner.configurationClassName = configurationClassName;
        this._runner.listener = listener;
        this._runner.start();
        try {
            if (!this._runner.waitForState(5000, (byte)1)) {
                throw new RuntimeException("Scope runner could not be started");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Scope runner could not be started: " + e.toString());
        }
    }

    private final class ScopeRunner
    extends AbstractSingleThreadRunner {
        private final Class _configurationSuperClass;
        protected IClassLoader classLoader;
        protected String configurationClassName;
        protected IScope.IScopeStateChangeListener listener;
        private byte _signal = (byte)-1;
        private Object _signalMutex;

        protected ScopeRunner(String name, Class configurationSuperClass) {
            super(name);
            this._configurationSuperClass = configurationSuperClass;
            this._signalMutex = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void doRun() {
            try {
                LifecycleHandler.SimpleLifecycleContext ref;
                try {
                    IContainerConfiguration configuration = (IContainerConfiguration)this.classLoader.loadClass(this.configurationClassName).newInstance();
                    if (!this._configurationSuperClass.isInstance(configuration)) {
                        throw new RuntimeException("excepted " + this._configurationSuperClass.getName() + " and got " + configuration.getClass().getName());
                    }
                    IContainer c = configuration.newInstance(this.classLoader);
                    ref = new LifecycleHandler.SimpleLifecycleContext(c);
                    Scope.this.getScopeMemory().setReference(ref);
                    configuration.configure(c);
                    c.addHandle(configuration);
                    try {
                        IReflector reflector = (IReflector)this.classLoader.loadClass("de.jiac.micro.internal.latebind.Reflector").newInstance();
                        c.addHandle(reflector);
                    }
                    catch (Exception e) {
                        c.getLogger().warn("no reflector found", (Throwable)e);
                    }
                    if (this.listener != null) {
                        this.listener.onSetup(Scope.this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.toString());
                }
                this.processSignals(ref);
            }
            finally {
                Scope.this.getScopeMemory().setReference(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void communicateSignal(byte signal) {
            Object object = this._signalMutex;
            synchronized (object) {
                this._signal = signal;
                this._signalMutex.notify();
            }
        }

        protected void forkExecution(Runnable runnable, String name) {
            ScopeImplBinder.createScopeAwareThread((Scope)Scope.this, (Runnable)runnable, (String)name).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSignals(LifecycleHandler.SimpleLifecycleContext ref) {
            Logger logger = ((IContainer)((Object)ref.lifecycleAware())).getLogger();
            block10: while (true) {
                byte currentSignal;
                Object object = this._signalMutex;
                synchronized (object) {
                    if (this._signal < 0) {
                        try {
                            this._signalMutex.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    currentSignal = this._signal;
                    this._signal = (byte)-1;
                }
                switch (currentSignal) {
                    case 1: 
                    case 2: {
                        boolean paused = currentSignal == 2;
                        LifecycleHandler.makeTransitionsTo(ref, (byte)2, logger);
                        if (!paused || this.listener == null) continue block10;
                        this.listener.onPause(Scope.this);
                        break;
                    }
                    case 3: 
                    case 4: {
                        LifecycleHandler.makeTransitionsTo(ref, (byte)3, logger);
                        if (this.listener == null) break;
                        this.listener.onStart(Scope.this);
                        break;
                    }
                    case 0: {
                        LifecycleHandler.makeTransitionsTo(ref, (byte)0, logger);
                        if (this.listener != null) {
                            this.listener.onTerminate(Scope.this);
                        }
                        return;
                    }
                }
            }
        }
    }
}

