/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.util;

import de.jiac.micro.core.scope.Scope;
import java.util.NoSuchElementException;

public class List {
    private static volatile int ONE = 1;
    private final transient Node _head = this.newNode();
    private final transient Node _tail = this.newNode();
    private final transient Node _emptyNodes = this.newNode();
    private volatile transient int _size;
    private final transient CapacityIncreaser _capacityIncreaser;

    public List() {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        this._size = 0;
        this._capacityIncreaser = new CapacityIncreaser();
    }

    public final synchronized Node addFirst(Object obj) {
        Node next;
        if (this._emptyNodes._next == null) {
            Scope.executeInScope(this._capacityIncreaser);
        }
        Node newNode = this._emptyNodes._next;
        this._emptyNodes._next = newNode._next;
        newNode._next = next = this._head._next;
        next._previous = newNode;
        this._head._next = newNode;
        newNode._previous = this._head;
        newNode._value = obj;
        this._size += ONE;
        return newNode;
    }

    public final synchronized Node addLast(Object obj) {
        Node previous;
        if (this._emptyNodes._next == null) {
            Scope.executeInScope(this._capacityIncreaser);
        }
        Node newNode = this._emptyNodes._next;
        this._emptyNodes._next = newNode._next;
        newNode._previous = previous = this._tail._previous;
        previous._next = newNode;
        this._tail._previous = newNode;
        newNode._next = this._tail;
        newNode._value = obj;
        this._size += ONE;
        return newNode;
    }

    public final synchronized boolean contains(Object obj) {
        return this.search(obj) != null;
    }

    public final synchronized Node get(int index) {
        Node node;
        if (this._size <= index || index < 0) {
            throw new NoSuchElementException("index out of bounds: " + index);
        }
        if (this._size >> 1 > index) {
            node = this._head;
            for (int i = index; i >= 0; --i) {
                node = node._next;
            }
        } else {
            node = this._tail;
            for (int i = index; i >= 0; --i) {
                node = node._previous;
            }
        }
        return node;
    }

    public final synchronized Object removeFirst() {
        if (this._head._next == this._tail) {
            return null;
        }
        Node first = this._head._next;
        Object val = first._value;
        this.delete(first);
        return val;
    }

    public final synchronized Object removeLast() {
        if (this._tail._previous == this._head) {
            return null;
        }
        Node last = this._tail._previous;
        Object val = last._value;
        this.delete(last);
        return val;
    }

    public final synchronized boolean remove(Object obj) {
        Node node = this.search(obj);
        if (node != null) {
            this.delete(node);
            return true;
        }
        return false;
    }

    public final synchronized void clear() {
        Node node;
        while ((node = this._head._next) != this._tail) {
            this.delete(node);
        }
    }

    public final Node head() {
        return this._head;
    }

    public final Node tail() {
        return this._tail;
    }

    public final int size() {
        return this._size;
    }

    protected Node newNode() {
        return new Node();
    }

    public final synchronized Node search(Object value) {
        Node node = this._head;
        while ((node = node._next) != this._tail) {
            if (!(value == null ? node._value == null : value == node._value || value.equals(node._value))) continue;
            return node;
        }
        return null;
    }

    public final synchronized void delete(Node node) {
        if (this._emptyNodes._previous != null) {
            this._emptyNodes._previous._previous = null;
            this._emptyNodes._previous._next = this._emptyNodes._next;
            this._emptyNodes._next = this._emptyNodes._previous;
            this._emptyNodes._previous = null;
        }
        this._size -= ONE;
        node._value = null;
        node._next._previous = node._previous;
        node._previous._next = node._next;
        this._emptyNodes._previous = node;
        node._next = this._tail._next;
        node._previous = this._tail;
        this._tail._next = node;
    }

    private final class CapacityIncreaser
    implements Runnable {
        CapacityIncreaser() {
        }

        public synchronized void run() {
            if (List.this._emptyNodes.next() != null || List.this._emptyNodes.previous() != null) {
                return;
            }
            Node node = List.this._emptyNodes;
            for (int i = 0; i < 4; ++i) {
                node._next = List.this.newNode();
                node._next._previous = node;
                node = node._next;
            }
        }
    }

    public static class Node {
        Object _value;
        Node _next;
        Node _previous;

        public final Node next() {
            return this._next;
        }

        public final Node previous() {
            return this._previous;
        }

        public final Object value() {
            return this._value;
        }
    }
}

