/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.internal.core;

import com.github.libxjava.lang.IClassLoader;
import de.jiac.micro.core.INode;
import de.jiac.micro.core.IScope;
import de.jiac.micro.core.LifecycleHandler;
import de.jiac.micro.core.scope.AgentScope;
import de.jiac.micro.internal.core.AbstractContainer;
import de.jiac.micro.internal.core.AbstractNodeComponent;
import de.jiac.micro.internal.core.AbstractNodeConfiguration;
import de.jiac.micro.util.List;

public abstract class AbstractNode
extends AbstractContainer
implements INode,
IScope.IScopeStateChangeListener {
    private final List _nodeComponents = new List(){

        protected List.Node newNode() {
            return new ComponentContext();
        }
    };
    private final List _agentScopes = new List();
    static /* synthetic */ Class class$de$jiac$micro$internal$core$AbstractNodeConfiguration;

    protected AbstractNode() {
    }

    public void setNodeComponents(AbstractNodeComponent[] nodeComponents) {
        if (nodeComponents != null && this._nodeComponents.size() <= 0) {
            for (int i = 0; i < nodeComponents.length; ++i) {
                this.addNodeComponent(nodeComponents[i]);
            }
        }
    }

    public void initialise() {
        this.getLogger().debug("initialising node");
        List.Node n = this._nodeComponents.head();
        List.Node end = this._nodeComponents.tail();
        while ((n = n.next()) != end) {
            ComponentContext context = (ComponentContext)n;
            this.initialiseComponent(context);
        }
        AbstractNodeConfiguration config = (AbstractNodeConfiguration)this.getHandle(class$de$jiac$micro$internal$core$AbstractNodeConfiguration == null ? (class$de$jiac$micro$internal$core$AbstractNodeConfiguration = AbstractNode.class$("de.jiac.micro.internal.core.AbstractNodeConfiguration")) : class$de$jiac$micro$internal$core$AbstractNodeConfiguration);
        String[] initialAgentConfigurations = config.agentClassNames;
        for (int i = 0; i < initialAgentConfigurations.length; ++i) {
            String agentConfigurationName = initialAgentConfigurations[i];
            AgentScope agentScope = new AgentScope();
            this._agentScopes.addLast(agentScope);
            agentScope.setup(this.getClassLoaderForAgent(null), agentConfigurationName, this);
        }
        this.traverseAgentScopes((byte)1);
        this.getLogger().debug("node initialised");
    }

    public void start() {
        this.getLogger().debug("starting node");
        List.Node n = this._nodeComponents.head();
        List.Node end = this._nodeComponents.tail();
        while ((n = n.next()) != end) {
            ComponentContext context = (ComponentContext)n;
            this.startComponent(context);
        }
        this.traverseAgentScopes((byte)3);
        this.getLogger().debug("node started");
    }

    public void stop() {
        this.getLogger().debug("stopping node");
        this.traverseAgentScopes((byte)2);
        List.Node n = this._nodeComponents.head();
        List.Node end = this._nodeComponents.tail();
        while ((n = n.next()) != end) {
            ComponentContext context = (ComponentContext)n;
            this.startComponent(context);
        }
        this.getLogger().debug("node stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List.Node n;
        this.getLogger().debug("cleaning up node");
        this.traverseAgentScopes((byte)0);
        List list = this._agentScopes;
        synchronized (list) {
            long currentTime;
            long maxblock = System.currentTimeMillis() + 3000L;
            while (this._agentScopes.size() > 0 && (currentTime = System.currentTimeMillis()) < maxblock) {
                try {
                    this._agentScopes.wait(maxblock - currentTime);
                }
                catch (InterruptedException e) {
                    this.getLogger().debug("waiting for agents to clean up", (Throwable)e);
                }
            }
        }
        List.Node head = this._nodeComponents.head();
        List.Node end = this._nodeComponents.tail();
        while ((n = head.next()) != end) {
            ComponentContext context = (ComponentContext)n;
            this.cleanupComponent(context);
            this._nodeComponents.delete(context);
        }
        this.getLogger().debug("node cleaned up");
    }

    protected abstract IClassLoader getClassLoaderForAgent(String[] var1);

    protected void addNodeComponent(AbstractNodeComponent nodeComponent) {
        this._nodeComponents.addLast(nodeComponent);
    }

    protected void removeNodeComponent(AbstractNodeComponent nodeComponent) {
        this._nodeComponents.remove(nodeComponent);
    }

    protected void initialiseComponent(ComponentContext context) {
        LifecycleHandler.makeTransitionsTo(context, (byte)2, this.getLogger());
        context.handle = context.getComponent().getNodeHandle();
        if (context.handle != null) {
            this.handles.addFirst(context.handle);
        }
    }

    protected void startComponent(ComponentContext context) {
        LifecycleHandler.makeTransitionsTo(context, (byte)3, this.getLogger());
    }

    protected void stopComponent(ComponentContext context) {
        LifecycleHandler.makeTransitionsTo(context, (byte)2, this.getLogger());
    }

    protected void cleanupComponent(ComponentContext context) {
        if (context.handle != null) {
            this.handles.remove(context.handle);
            context.handle = null;
        }
        LifecycleHandler.makeTransitionsTo(context, (byte)0, this.getLogger());
    }

    private void traverseAgentScopes(byte signal) {
        List.Node n = this._agentScopes.head();
        List.Node end = this._agentScopes.tail();
        while ((n = n.next()) != end) {
            AgentScope agentScope = (AgentScope)n.value();
            agentScope.signal(signal);
        }
    }

    public void onSetup(IScope scope) {
        List.Node n = this._nodeComponents.head();
        List.Node end = this._nodeComponents.tail();
        while ((n = n.next()) != end) {
            ComponentContext context = (ComponentContext)n;
            context.getComponent().addHandlesOn((AgentScope)scope);
        }
    }

    public void onStart(IScope scope) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminate(IScope scope) {
        List list = this._agentScopes;
        synchronized (list) {
            if (!this._agentScopes.remove(scope)) {
                throw new Error("Invalid state of node");
            }
            List.Node n = this._nodeComponents.head();
            List.Node end = this._nodeComponents.tail();
            while ((n = n.next()) != end) {
                ComponentContext context = (ComponentContext)n;
                context.getComponent().removeHandlesFrom((AgentScope)scope);
            }
            this._agentScopes.notify();
        }
    }

    public void onPause(IScope scope) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class ComponentContext
    extends LifecycleHandler.ListableLifecycleContext {
        public Object handle;

        protected ComponentContext() {
        }

        public AbstractNodeComponent getComponent() {
            return (AbstractNodeComponent)this.value();
        }
    }
}

