/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.internal.core;

import de.jiac.micro.agent.IActuator;
import de.jiac.micro.agent.IAgentElement;
import de.jiac.micro.agent.IConnectionFactory;
import de.jiac.micro.agent.ISensor;
import de.jiac.micro.agent.memory.IShortTermMemory;
import de.jiac.micro.core.IAgent;
import de.jiac.micro.core.IHandle;
import de.jiac.micro.core.LifecycleHandler;
import de.jiac.micro.internal.core.AbstractContainer;
import de.jiac.micro.util.List;
import java.util.Hashtable;
import org.slf4j.Logger;

public abstract class AbstractAgent
extends AbstractContainer
implements IAgent {
    protected List installedElements = new List(){

        protected List.Node newNode() {
            return new ElementContext();
        }
    };
    protected Hashtable properties = new Hashtable();

    public final Object getProperty(String key) {
        return this.properties.get(key);
    }

    public final void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            Class<?> expected = null;
            Object oldValue = this.properties.get(key);
            if (oldValue != null) {
                expected = oldValue.getClass();
            }
            if (expected != null && value.getClass() != expected) {
                Logger logger = this.getLogger();
                if (logger.isWarnEnabled()) {
                    logger.warn("ignore property change of '" + key + "': " + expected + " required but got " + value.getClass() + "");
                }
                return;
            }
            this.properties.put(key, value);
        }
    }

    public void initialise() {
        List.Node n = this.installedElements.head();
        List.Node end = this.installedElements.tail();
        while ((n = n.next()) != end) {
            ElementContext context = (ElementContext)n;
            this.initialiseElement(context);
        }
    }

    public void start() {
        List.Node n = this.installedElements.head();
        List.Node end = this.installedElements.tail();
        while ((n = n.next()) != end) {
            ElementContext context = (ElementContext)n;
            this.startElement(context);
        }
    }

    public void stop() {
        List.Node n = this.installedElements.head();
        List.Node end = this.installedElements.tail();
        while ((n = n.next()) != end) {
            ElementContext context = (ElementContext)n;
            this.stopElement(context);
        }
    }

    public void cleanup() {
        List.Node n;
        List.Node head = this.installedElements.head();
        List.Node end = this.installedElements.tail();
        while ((n = head.next()) != end) {
            ElementContext context = (ElementContext)n;
            this.cleanupElement(context);
            this.installedElements.delete(context);
        }
    }

    public void addAgentElement(IAgentElement agentElement) {
        if (this.findElementContext(agentElement) != null) {
            return;
        }
        this.installedElements.addLast(agentElement);
    }

    private final ElementContext findElementContext(IAgentElement element) {
        List.Node n = this.installedElements.head();
        List.Node end = this.installedElements.tail();
        while ((n = n.next()) != end) {
            ElementContext context = (ElementContext)n;
            if (context.getElement() != element) continue;
            return context;
        }
        return null;
    }

    protected void initialiseElement(ElementContext context) {
        IAgentElement element = context.getElement();
        if (element instanceof ISensor) {
            ((ISensor)element).setShortTermMemory(this.getShortTermMemory());
        }
        LifecycleHandler.makeTransitionsTo(context, (byte)2, this.getLogger());
        if (element instanceof IActuator) {
            context.handle = ((IActuator)element).getHandle();
            if (context.handle != null) {
                this.handles.addFirst(context.handle);
            }
        }
        if (element instanceof IConnectionFactory) {
            context.scheme = ((IConnectionFactory)((Object)element)).getScheme();
        }
    }

    protected void startElement(ElementContext context) {
        LifecycleHandler.makeTransitionsTo(context, (byte)3, this.getLogger());
    }

    protected void stopElement(ElementContext context) {
        LifecycleHandler.makeTransitionsTo(context, (byte)2, this.getLogger());
    }

    protected void cleanupElement(ElementContext context) {
        context.scheme = null;
        if (context.handle != null) {
            this.handles.remove(context.handle);
            context.handle = null;
        }
        LifecycleHandler.makeTransitionsTo(context, (byte)0, this.getLogger());
    }

    protected abstract IShortTermMemory getShortTermMemory();

    protected static class ElementContext
    extends LifecycleHandler.ListableLifecycleContext {
        public String id = null;
        public String scheme = null;
        public IHandle handle = null;

        protected ElementContext() {
        }

        public IAgentElement getElement() {
            return (IAgentElement)this.value();
        }
    }
}

